/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.core.store.csv.accessor;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.List;
import java.util.stream.Collectors;
import org.palladiosimulator.simexp.core.store.csv.accessor.CsvHandler;

public class CsvReadHandler
extends CsvHandler {
    private File csvFile;

    private CsvReadHandler(String folder, String file) {
        try {
            this.csvFile = CsvReadHandler.createCsvFile(folder, file);
        }
        catch (IOException e) {
            throw new RuntimeException("");
        }
    }

    private CsvReadHandler(File csvFile) {
        this.csvFile = csvFile;
    }

    public static CsvReadHandler load(File csvFile) {
        return new CsvReadHandler(csvFile);
    }

    public static CsvReadHandler create(String folder, String file) {
        return new CsvReadHandler(folder, file);
    }

    private BufferedReader getReader() {
        BufferedReader reader = null;
        try {
            reader = Files.newBufferedReader(this.csvFile.toPath());
        }
        catch (IOException e) {
            new RuntimeException("");
        }
        return reader;
    }

    @Override
    public void close() {
        this.csvFile = null;
    }

    public List<String> getAllRows() {
        BufferedReader reader = this.getReader();
        try {
            List<String> list = reader.lines().collect(Collectors.toList());
            return list;
        }
        finally {
            this.close(reader);
        }
    }

    private void close(Reader reader) {
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getRowAt(int index) throws IndexOutOfBoundsException {
        return this.getAllRows().get(index);
    }

    public boolean isEmptyFile() {
        return this.getAllRows().size() == 0;
    }
}

