/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.core.store.csv.accessor;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.palladiosimulator.simexp.core.entity.SimulatedExperience;
import org.palladiosimulator.simexp.core.store.SimulatedExperienceAccessor;
import org.palladiosimulator.simexp.core.store.SimulatedExperienceCache;
import org.palladiosimulator.simexp.core.store.SimulatedExperienceStoreDescription;
import org.palladiosimulator.simexp.core.store.csv.accessor.CsvFormatter;
import org.palladiosimulator.simexp.core.store.csv.accessor.CsvHandler;
import org.palladiosimulator.simexp.core.store.csv.accessor.CsvReadHandler;
import org.palladiosimulator.simexp.core.store.csv.accessor.CsvSimulatedExperience;
import org.palladiosimulator.simexp.core.store.csv.accessor.CsvWriteHandler;

public class CsvAccessor
implements SimulatedExperienceAccessor {
    private Optional<SimulatedExperienceCache> cache = Optional.empty();
    private CsvWriteHandler csvSampleWriteHandler = null;
    private CsvWriteHandler csvStoreWriteHandler = null;
    private CsvReadHandler csvSampleReadHandler = null;
    private CsvReadHandler csvStoreReadHandler = null;

    public void connect(SimulatedExperienceStoreDescription desc) {
        File csvStoreFile = CsvHandler.loadCsvFile(desc.getSimulationId(), "SimulatedExperienceStore");
        if (csvStoreFile.exists()) {
            File csvSampleSpaceFile = CsvHandler.loadOrCreate(desc.getSimulationId(), CsvHandler.constructSampleSpaceFileName(desc.getSampleSpaceId()));
            this.csvSampleWriteHandler = CsvWriteHandler.load(csvSampleSpaceFile);
            this.csvSampleReadHandler = CsvReadHandler.load(csvSampleSpaceFile);
            this.csvStoreWriteHandler = CsvWriteHandler.load(csvStoreFile);
            this.csvStoreReadHandler = CsvReadHandler.load(csvStoreFile);
        } else {
            this.csvSampleWriteHandler = CsvWriteHandler.create(desc.getSimulationId(), CsvHandler.constructSampleSpaceFileName(desc.getSampleSpaceId()));
            this.csvSampleReadHandler = CsvReadHandler.create(desc.getSimulationId(), CsvHandler.constructSampleSpaceFileName(desc.getSampleSpaceId()));
            this.csvStoreWriteHandler = CsvWriteHandler.create(desc.getSimulationId(), "SimulatedExperienceStore");
            this.csvStoreReadHandler = CsvReadHandler.create(desc.getSimulationId(), "SimulatedExperienceStore");
        }
        if (this.csvSampleReadHandler.isEmptyFile()) {
            this.csvSampleWriteHandler.append(CsvFormatter.formatSampleSpaceHeader(desc.getSampleHorizon()));
        }
        if (this.csvStoreReadHandler.isEmptyFile()) {
            this.csvStoreWriteHandler.append(CsvFormatter.formatSimulatedExperienceStoreHeader());
        }
    }

    public void store(SimulatedExperience simulatedExperience) {
        Objects.requireNonNull(this.csvStoreWriteHandler, "");
        Objects.requireNonNull(this.csvSampleWriteHandler, "");
        this.csvStoreWriteHandler.append(simulatedExperience);
    }

    public void store(List<SimulatedExperience> trajectory) {
        Objects.requireNonNull(this.csvStoreWriteHandler, "");
        Objects.requireNonNull(this.csvSampleWriteHandler, "");
        this.csvSampleWriteHandler.append(trajectory);
    }

    public void close() {
        this.csvStoreReadHandler.close();
        this.csvStoreWriteHandler.close();
        this.csvSampleWriteHandler.close();
    }

    public Optional<SimulatedExperience> findSimulatedExperience(String id) {
        Objects.requireNonNull(this.csvStoreReadHandler, "");
        Optional<SimulatedExperience> result = this.queryCache(id);
        if (result.isPresent()) {
            return result;
        }
        result = this.queryStoreWithFull(id);
        result.ifPresent(s -> this.putInCache(id, (SimulatedExperience)s));
        return result;
    }

    public Optional<SimulatedExperience> findSelfAdaptiveSystemState(String id) {
        Objects.requireNonNull(this.csvStoreReadHandler, "");
        Optional<SimulatedExperience> result = this.queryCache(id);
        if (result.isPresent()) {
            return result;
        }
        result = this.queryStoreWithPrefix(id);
        result.ifPresent(s -> this.putInCache(id, (SimulatedExperience)s));
        return result;
    }

    public Optional<List<SimulatedExperience>> getTrajectoryAt(int index) {
        Objects.requireNonNull(this.csvSampleReadHandler, "");
        ++index;
        try {
            String[] row = this.csvSampleReadHandler.getRowAt(index).split(";");
            return Optional.of(this.toTrajectory(row));
        }
        catch (IndexOutOfBoundsException e) {
            return Optional.empty();
        }
    }

    private List<SimulatedExperience> toTrajectory(String[] row) {
        ArrayList<SimulatedExperience> traj = new ArrayList<SimulatedExperience>();
        int i = 0;
        while (i < row.length) {
            String simExpId = row[i];
            String reward = row[i + 1];
            traj.add(this.restoreSimulatedExperience(simExpId, reward));
            i += 2;
        }
        return traj;
    }

    private SimulatedExperience restoreSimulatedExperience(String simExpId, String reward) {
        CsvSimulatedExperience simExp = (CsvSimulatedExperience)this.findSimulatedExperience(simExpId).orElseThrow(() -> new RuntimeException(""));
        simExp.setReward(reward);
        return simExp;
    }

    private Optional<SimulatedExperience> queryStoreWithFull(String id) {
        return this.queryForSimulatedExperience(CsvFormatter.withSameId(id));
    }

    private Optional<SimulatedExperience> queryStoreWithPrefix(String id) {
        return this.queryForSimulatedExperience(CsvFormatter.startingWith(id));
    }

    private Optional<SimulatedExperience> queryForSimulatedExperience(Predicate<String> criterion) {
        Stream lines = this.csvStoreReadHandler.getAllRows().stream();
        return lines.filter(criterion).map(row -> CsvSimulatedExperience.of(row)).findFirst();
    }

    private Optional<SimulatedExperience> queryCache(String id) {
        if (this.cache.isPresent()) {
            return this.cache.get().load(id);
        }
        return Optional.empty();
    }

    private void putInCache(String id, SimulatedExperience simulatedExperience) {
        this.cache.ifPresent(c -> c.put(id, simulatedExperience));
    }

    public void setOptionalCache(SimulatedExperienceCache cache) {
        this.cache = Optional.of(cache);
    }
}

