/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.core.store.csv.accessor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.palladiosimulator.simexp.core.entity.SimulatedExperience;

public class CsvFormatter {
    public static final String CSV_DELIMITER = ";";
    private static final String ID_TAG = "Id";
    private static final String TIME_TAG = "Point in time";
    private static final String ENVIRONMENTAL_STATE_BEFORE_TAG = "Environmental state before";
    private static final String ENVIRONMENTAL_STATE_AFTER_TAG = "Environmental state after";
    private static final String ENVIRONMENTAL_STATE_OBSERVATION_TAG = "Environmental state observation";
    private static final String RECONFIGURATION_TAG = "Reconfiguration";
    private static final String CONFIGURATION_BEFOR_TAG = "Configuration before";
    private static final String CONFIGURATION_AFTER_TAG = "Configuration after";
    private static final String QUANTIFIED_STATE_CURRENT_TAG = "Quantified state current";
    private static final String QUANTIFIED_STATE_NEXT_TAG = "Quantified state next";
    private static final String REWARD_TAG = "Reward";

    public static String formatSampleSpaceHeader(int trajectoryLength) {
        ArrayList<String> values = new ArrayList<String>();
        int i = 1;
        while (i < trajectoryLength) {
            values.add(String.format("%1s: %2s", TIME_TAG, Integer.toString(i - 1)));
            values.add(REWARD_TAG);
            ++i;
        }
        return new RowFormatter(values).toRow();
    }

    public static String formatSimulatedExperienceStoreHeader() {
        List<String> values = Arrays.asList(ID_TAG, ENVIRONMENTAL_STATE_BEFORE_TAG, QUANTIFIED_STATE_CURRENT_TAG, CONFIGURATION_BEFOR_TAG, RECONFIGURATION_TAG, CONFIGURATION_AFTER_TAG, QUANTIFIED_STATE_NEXT_TAG, ENVIRONMENTAL_STATE_AFTER_TAG, ENVIRONMENTAL_STATE_OBSERVATION_TAG);
        return new RowFormatter(values).toRow();
    }

    public static String format(List<SimulatedExperience> trajectory) {
        ArrayList<String> values = new ArrayList<String>();
        for (SimulatedExperience each : trajectory) {
            values.add(each.getId());
            values.add(each.getReward());
        }
        return new RowFormatter(values).toRow();
    }

    public static String format(SimulatedExperience simulatedExperience) {
        return new RowFormatter(CsvFormatter.toList(simulatedExperience)).toRow();
    }

    private static List<String> toList(SimulatedExperience simulatedExperience) {
        return Arrays.asList(simulatedExperience.getId(), simulatedExperience.getEnvironmentalStateBefore(), simulatedExperience.getQuantifiedStateOfCurrent(), simulatedExperience.getConfigurationDifferenceBefore(), simulatedExperience.getReconfiguration(), simulatedExperience.getConfigurationDifferenceAfter(), simulatedExperience.getQuantifiedStateOfNext(), simulatedExperience.getEnvironmentalStateAfter(), simulatedExperience.getEnvironmentalStateObservation());
    }

    public static Predicate<String> withSameId(String id) {
        return row -> CsvFormatter.getId(row).equals(id);
    }

    public static Predicate<String> startingWith(String id) {
        return row -> CsvFormatter.getId(row).startsWith(id);
    }

    private static String getId(String row) {
        return row.split(CSV_DELIMITER)[0];
    }

    private static class RowFormatter {
        private final String delimiter;
        private final List<String> values;

        public RowFormatter(List<String> values) {
            this(values, CsvFormatter.CSV_DELIMITER);
        }

        public RowFormatter(List<String> values, String delimiter) {
            this.values = values;
            this.delimiter = delimiter;
        }

        public String toRow() {
            StringBuilder builder = new StringBuilder();
            for (String each : this.values) {
                builder.append(this.withDelimiter(each));
            }
            this.deleteLastDelimiter(builder);
            return builder.toString();
        }

        private String withDelimiter(String value) {
            return String.valueOf(value) + this.delimiter;
        }

        private void deleteLastDelimiter(StringBuilder builder) {
            builder.deleteCharAt(builder.lastIndexOf(this.delimiter));
        }
    }

    public static enum SimulatedExperienceStoreColumnName {
        ID(0),
        ENVIRONMENTAL_STATE_BEFORE(1),
        QUANTIFIED_STATE_CURRENT(2),
        CONFIGURATION_BEFOR(3),
        RECONFIGURATION(4),
        CONFIGURATION_AFTER(5),
        QUANTIFIED_STATE_NEXT(6),
        ENVIRONMENTAL_STATE_AFTER(7),
        ENVIRONMENTAL_STATE_OBSERVATION(8);

        private final int index;

        private SimulatedExperienceStoreColumnName(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

