/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.core.store.csv.accessor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.palladiosimulator.simexp.core.entity.SimulatedExperience;
import org.palladiosimulator.simexp.core.store.csv.accessor.CsvFormatter;
import org.palladiosimulator.simexp.core.store.csv.accessor.CsvHandler;

public class CsvWriteHandler
extends CsvHandler {
    private final PrintWriter csvWriter;

    private CsvWriteHandler(String folder, String file) {
        this.csvWriter = this.createCsvWriter(folder, file);
    }

    private CsvWriteHandler(File csvFile) {
        this.csvWriter = this.loadCsvWriterWithAppendMode(csvFile);
    }

    public static CsvWriteHandler create(String folder, String file) {
        return new CsvWriteHandler(folder, file);
    }

    public static CsvWriteHandler load(File csvFile) {
        return new CsvWriteHandler(csvFile);
    }

    private PrintWriter createCsvWriter(String folder, String file) {
        try {
            File csvFile = CsvWriteHandler.createCsvFile(folder, file);
            return this.loadCsvWriterWithoutAppendMode(csvFile);
        }
        catch (IOException e) {
            throw new RuntimeException("", e);
        }
    }

    private PrintWriter loadCsvWriterWithoutAppendMode(File csvFile) {
        return this.loadCsvWriter(csvFile, false);
    }

    private PrintWriter loadCsvWriterWithAppendMode(File csvFile) {
        return this.loadCsvWriter(csvFile, true);
    }

    private PrintWriter loadCsvWriter(File csvFile, boolean append) {
        try {
            BufferedWriter csvWritter = new BufferedWriter(new FileWriter(csvFile, append));
            return new PrintWriter(csvWritter);
        }
        catch (IOException e) {
            throw new RuntimeException("", e);
        }
    }

    public void append(List<SimulatedExperience> trajectory) {
        this.csvWriter.println(CsvFormatter.format(trajectory));
    }

    public void append(SimulatedExperience simulatedExperience) {
        this.csvWriter.println(CsvFormatter.format(simulatedExperience));
    }

    public void append(String value) {
        this.csvWriter.println(value);
    }

    @Override
    public void close() {
        this.csvWriter.close();
    }
}

