/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.core.process;

import java.util.List;
import org.apache.log4j.Logger;
import org.palladiosimulator.simexp.core.process.ExperienceSimulationConfiguration;
import org.palladiosimulator.simexp.core.process.ExperienceSimulationRunner;
import org.palladiosimulator.simexp.core.process.Initializable;
import org.palladiosimulator.simexp.core.state.SimulationRunnerHolder;
import org.palladiosimulator.simexp.core.store.SimulatedExperienceStore;
import org.palladiosimulator.simexp.markovian.model.markovmodel.samplemodel.Sample;
import org.palladiosimulator.simexp.markovian.model.markovmodel.samplemodel.Trajectory;
import org.palladiosimulator.simexp.markovian.sampling.MarkovSampling;

public class ExperienceSimulator<C, A, R> {
    private static final Logger LOGGER = Logger.getLogger(ExperienceSimulator.class);
    private final MarkovSampling<A, R> markovSampler;
    private final List<ExperienceSimulationRunner> simulationRunners;
    private final List<Initializable> beforeExecutionInitializations;
    private final SimulatedExperienceStore<A, R> simulatedExperienceStore;
    private final int numberOfRuns;

    private ExperienceSimulator(ExperienceSimulationConfiguration<C, A, R> config, SimulatedExperienceStore<A, R> simulatedExperienceStore, SimulationRunnerHolder simulationRunnerHolder) {
        this.numberOfRuns = config.getNumberOfRuns();
        this.markovSampler = config.getMarkovSampler();
        this.simulationRunners = config.getSimulationRunners();
        this.beforeExecutionInitializations = config.getBeforeExecutionInitialization();
        simulationRunnerHolder.registerSimulationRunners(this.simulationRunners);
        this.simulatedExperienceStore = simulatedExperienceStore;
    }

    public static <S, A, R> ExperienceSimulator<S, A, R> createSimulator(ExperienceSimulationConfiguration<S, A, R> config, SimulatedExperienceStore<A, R> simulatedExperienceStore, SimulationRunnerHolder simulationRunnerHolder) {
        return new ExperienceSimulator<S, A, R>(config, simulatedExperienceStore, simulationRunnerHolder);
    }

    public void run() {
        int run = 0;
        while (run < this.numberOfRuns) {
            LOGGER.info((Object)String.format("Start simulator run: %d/%d", run + 1, this.numberOfRuns));
            this.initExperienceSimulator();
            this.runExperienceSimulator();
            LOGGER.info((Object)String.format("End simulator run: %d/%d", run + 1, this.numberOfRuns));
            ++run;
        }
    }

    private void initExperienceSimulator() {
        this.beforeExecutionInitializations.stream().forEach(Initializable::initialize);
        this.simulationRunners.stream().filter(Initializable.class::isInstance).map(Initializable.class::cast).forEach(Initializable::initialize);
    }

    private void runExperienceSimulator() {
        Trajectory traj = this.markovSampler.sampleTrajectory();
        for (Sample each : traj.getSamplePath()) {
            this.simulatedExperienceStore.store(each);
        }
        this.simulatedExperienceStore.store(traj);
    }
}

