/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.core.strategy;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public class SharedKnowledge {
    private final Map<String, Object> knowledgeStore = Maps.newHashMap();

    public void store(String key, Object value) {
        this.knowledgeStore.put(key, value);
    }

    public <T> Optional<T> getValue(String key) {
        Optional<Object> result = Optional.ofNullable(this.knowledgeStore.get(key));
        if (result.isPresent()) {
            return result.map(v -> v);
        }
        return Optional.empty();
    }

    public Collection<Object> getValues() {
        return this.knowledgeStore.values();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SharedKnowledge[");
        Iterator<Map.Entry<String, Object>> iter = this.knowledgeStore.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            sb.append(entry.getKey());
            sb.append('=').append('\"');
            sb.append(entry.getValue());
            sb.append('\"');
            if (!iter.hasNext()) continue;
            sb.append(',').append(' ');
        }
        sb.append("]");
        return sb.toString();
    }
}

