/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.core.evaluation;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.palladiosimulator.simexp.core.entity.DefaultSimulatedExperience;
import org.palladiosimulator.simexp.core.entity.SimulatedExperience;
import org.palladiosimulator.simexp.core.evaluation.SampleModelIterator;
import org.palladiosimulator.simexp.core.evaluation.TotalRewardCalculation;
import org.palladiosimulator.simexp.core.valuefunction.MonteCarloPrediction;
import org.palladiosimulator.simexp.core.valuefunction.ValueFunction;

public class ExpectedRewardEvaluator
implements TotalRewardCalculation {
    private final String simulationId;
    private final String sampleSpaceId;

    public ExpectedRewardEvaluator(String simulationId, String sampleSpaceId) {
        this.simulationId = simulationId;
        this.sampleSpaceId = sampleSpaceId;
    }

    @Override
    public double computeTotalReward() {
        SampleModelIterator iterator = SampleModelIterator.get(this.simulationId, this.sampleSpaceId);
        ValueFunction valueFunction = MonteCarloPrediction.firstVisitEstimation().estimate(iterator);
        InitialStateEstimator initialStateEstimator = new InitialStateEstimator();
        double totalReward = 0.0;
        for (String each : initialStateEstimator.filterInitialStates()) {
            double reward = valueFunction.getExpectedRewardFor(each);
            double probability = initialStateEstimator.estimateProbability(each);
            totalReward += probability * reward;
        }
        return totalReward;
    }

    private class InitialStateEstimator {
        private final List<String> sampledInitials = this.filterSampledInitials();

        private List<String> filterSampledInitials() {
            ArrayList sampledInitials = Lists.newArrayList();
            SampleModelIterator iterator = SampleModelIterator.get(ExpectedRewardEvaluator.this.simulationId, ExpectedRewardEvaluator.this.sampleSpaceId);
            while (iterator.hasNext()) {
                String initial = DefaultSimulatedExperience.getCurrentStateFrom((SimulatedExperience)iterator.next().get(0));
                sampledInitials.add(initial);
            }
            return sampledInitials;
        }

        public Set<String> filterInitialStates() {
            LinkedHashSet initials = Sets.newLinkedHashSet();
            for (String each : this.sampledInitials) {
                if (initials.contains(each)) continue;
                initials.add(each);
            }
            return initials;
        }

        public double estimateProbability(String initial) {
            double relativeCount = this.sampledInitials.stream().filter(each -> each.equals(initial)).count();
            return relativeCount / (double)this.sampledInitials.size();
        }
    }
}

