/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.core.store;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.palladiosimulator.simexp.core.entity.DefaultSimulatedExperience;
import org.palladiosimulator.simexp.core.entity.SimulatedExperience;
import org.palladiosimulator.simexp.core.store.DescriptionProvider;
import org.palladiosimulator.simexp.core.store.SimulatedExperienceAccessor;
import org.palladiosimulator.simexp.core.store.SimulatedExperienceCache;
import org.palladiosimulator.simexp.core.store.SimulatedExperienceStoreDescription;
import org.palladiosimulator.simexp.markovian.model.markovmodel.samplemodel.Sample;
import org.palladiosimulator.simexp.markovian.model.markovmodel.samplemodel.Trajectory;
import org.palladiosimulator.simexp.service.registry.ServiceRegistry;

public class SimulatedExperienceStore<A, R> {
    private final DescriptionProvider descriptionProvider;
    private final SimulatedExperienceAccessor simExperienceAccessor;

    public SimulatedExperienceStore(DescriptionProvider descriptionProvider) {
        this.descriptionProvider = descriptionProvider;
        this.simExperienceAccessor = (SimulatedExperienceAccessor)ServiceRegistry.get().findService(SimulatedExperienceAccessor.class).orElseThrow(() -> new RuntimeException(""));
        ServiceRegistry.get().findService(SimulatedExperienceCache.class).ifPresent(cache -> this.simExperienceAccessor.setOptionalCache((SimulatedExperienceCache)cache));
    }

    public void store(Trajectory<A, R> trajectory) {
        SimulatedExperienceStoreDescription description = this.descriptionProvider.getDescription();
        this.simExperienceAccessor.connect(description);
        this.simExperienceAccessor.store(this.toSimulatedExperience(trajectory));
        this.simExperienceAccessor.close();
    }

    private List<SimulatedExperience> toSimulatedExperience(Trajectory<A, R> trajectory) {
        return trajectory.getSamplePath().stream().map(each -> DefaultSimulatedExperience.of(each)).collect(Collectors.toList());
    }

    public void store(Sample<A, R> sample) {
        DefaultSimulatedExperience simExp = DefaultSimulatedExperience.of(sample);
        if (this.isAlreadyStored(simExp)) {
            return;
        }
        SimulatedExperienceStoreDescription description = this.descriptionProvider.getDescription();
        this.simExperienceAccessor.connect(description);
        this.simExperienceAccessor.store(simExp);
        this.simExperienceAccessor.close();
    }

    private boolean isAlreadyStored(SimulatedExperience simExp) {
        return this.findSimulatedExperience(simExp.getId()).isPresent();
    }

    public Optional<SimulatedExperience> findSimulatedExperience(String id) {
        SimulatedExperienceStoreDescription description = this.descriptionProvider.getDescription();
        this.simExperienceAccessor.connect(description);
        Optional<SimulatedExperience> result = this.simExperienceAccessor.findSimulatedExperience(id);
        this.simExperienceAccessor.close();
        return result;
    }

    public Optional<SimulatedExperience> findSelfAdaptiveSystemState(String id) {
        SimulatedExperienceStoreDescription description = this.descriptionProvider.getDescription();
        this.simExperienceAccessor.connect(description);
        Optional<SimulatedExperience> result = this.simExperienceAccessor.findSelfAdaptiveSystemState(id);
        this.simExperienceAccessor.close();
        return result;
    }
}

