/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.core.process;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.palladiosimulator.simexp.core.process.ExperienceSimulationRunner;
import org.palladiosimulator.simexp.core.process.Initializable;
import org.palladiosimulator.simexp.markovian.sampling.MarkovSampling;

public class ExperienceSimulationConfiguration<C, A, R> {
    private int horizon = 0;
    private int numberOfRuns = 0;
    private String simulationID = "";
    private String sampleSpaceID = "";
    private List<ExperienceSimulationRunner> runners = Lists.newArrayList();
    private MarkovSampling<A, R> markovSampler = null;
    private List<Initializable> beforeExecutionInitializables = Lists.newArrayList();

    private ExperienceSimulationConfiguration() {
    }

    public int getHorizon() {
        return this.horizon;
    }

    public int getNumberOfRuns() {
        return this.numberOfRuns;
    }

    public String getSimulationID() {
        return this.simulationID;
    }

    public List<ExperienceSimulationRunner> getSimulationRunners() {
        return this.runners;
    }

    public MarkovSampling<A, R> getMarkovSampler() {
        return this.markovSampler;
    }

    public String getSampleSpaceID() {
        return this.sampleSpaceID;
    }

    public static <S, A, R> ExperienceSimulationConfigBuilder newBuilder() {
        ExperienceSimulationConfiguration experienceSimulationConfiguration = new ExperienceSimulationConfiguration();
        return experienceSimulationConfiguration.new ExperienceSimulationConfigBuilder();
    }

    public List<Initializable> getBeforeExecutionInitialization() {
        return this.beforeExecutionInitializables;
    }

    public class ExperienceSimulationConfigBuilder {
        public ExperienceSimulationConfigBuilder withSimulationID(String simulationID) {
            ExperienceSimulationConfiguration.this.simulationID = simulationID;
            return this;
        }

        public ExperienceSimulationConfigBuilder withSampleSpaceID(String sampleSpaceID) {
            ExperienceSimulationConfiguration.this.sampleSpaceID = sampleSpaceID;
            return this;
        }

        public ExperienceSimulationConfigBuilder withNumberOfRuns(int numOfRuns) {
            ExperienceSimulationConfiguration.this.numberOfRuns = numOfRuns;
            return this;
        }

        public ExperienceSimulationConfigBuilder executeBeforeEachRun(List<Initializable> beforeExecutionInitializables) {
            if (beforeExecutionInitializables != null) {
                ExperienceSimulationConfiguration.this.beforeExecutionInitializables = beforeExecutionInitializables;
            }
            return this;
        }

        public ExperienceSimulationConfigBuilder addSimulationRunner(List<ExperienceSimulationRunner> runners) {
            ExperienceSimulationConfiguration.this.runners.addAll(runners);
            return this;
        }

        public ExperienceSimulationConfigBuilder addSimulationRunner(ExperienceSimulationRunner runner) {
            ExperienceSimulationConfiguration.this.runners.add(runner);
            return this;
        }

        public ExperienceSimulationConfigBuilder sampleWith(MarkovSampling<A, R> markovSampler) {
            ExperienceSimulationConfiguration.this.markovSampler = markovSampler;
            return this;
        }

        public ExperienceSimulationConfiguration<C, A, R> build() {
            this.checkValidity();
            return ExperienceSimulationConfiguration.this;
        }

        private void checkValidity() {
            Objects.requireNonNull(ExperienceSimulationConfiguration.this.runners, "");
            Objects.requireNonNull(ExperienceSimulationConfiguration.this.markovSampler, "");
            if (this.isNegative(ExperienceSimulationConfiguration.this.numberOfRuns) || this.isNegative(ExperienceSimulationConfiguration.this.horizon)) {
                throw new RuntimeException("");
            }
            if (this.isEmptyString(ExperienceSimulationConfiguration.this.simulationID) || this.isEmptyString(ExperienceSimulationConfiguration.this.sampleSpaceID)) {
                throw new RuntimeException("");
            }
        }

        private boolean isNegative(int value) {
            return value < 0;
        }

        private boolean isEmptyString(String value) {
            return value == "";
        }
    }
}

