/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.core.statespace;

import java.util.Optional;
import org.apache.log4j.Logger;
import org.palladiosimulator.simexp.core.action.Reconfiguration;
import org.palladiosimulator.simexp.core.state.ArchitecturalConfiguration;
import org.palladiosimulator.simexp.core.state.SelfAdaptiveSystemState;
import org.palladiosimulator.simexp.core.state.SimulationRunnerHolder;
import org.palladiosimulator.simexp.core.statespace.SelfAdaptiveSystemStateSpaceNavigator;
import org.palladiosimulator.simexp.core.store.SimulatedExperienceStore;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivableEnvironmentalState;
import org.palladiosimulator.simexp.environmentaldynamics.process.EnvironmentProcess;
import org.palladiosimulator.simexp.markovian.statespace.StateSpaceNavigator;

public class EnvironmentDrivenStateSpaceNavigator<C, A, R, V>
extends SelfAdaptiveSystemStateSpaceNavigator<C, A, R, V> {
    private static final Logger LOGGER = Logger.getLogger(EnvironmentDrivenStateSpaceNavigator.class);

    private EnvironmentDrivenStateSpaceNavigator(EnvironmentProcess<A, R, V> environmentalDynamics, SimulatedExperienceStore<A, R> simulatedExperienceStore, SimulationRunnerHolder simulationRunnerHolder) {
        super(environmentalDynamics, simulatedExperienceStore, simulationRunnerHolder);
    }

    public static <C, A, R, V> EnvironmentDrivenStateSpaceNavigator<C, A, R, V> with(EnvironmentProcess<A, R, V> environmentProcess, SimulatedExperienceStore<A, R> simulatedExperienceStore, SimulationRunnerHolder simulationRunnerHolder) {
        return new EnvironmentDrivenStateSpaceNavigator<C, A, R, V>(environmentProcess, simulatedExperienceStore, simulationRunnerHolder);
    }

    @Override
    public SelfAdaptiveSystemState<C, A, V> determineStructuralState(StateSpaceNavigator.NavigationContext<A> context) {
        Optional action = context.getAction();
        Reconfiguration reconf = (Reconfiguration)action.get();
        PerceivableEnvironmentalState nextEnvState = this.environmentalDynamics.determineNextGiven(this.getLastEnvironmentalState(context));
        ArchitecturalConfiguration<C, A> nextArchConf = this.getLastArchitecturalConfig(context).apply(reconf);
        LOGGER.info((Object)"==== End MAPE-K loop ====");
        SelfAdaptiveSystemState<C, A, V> nextState = this.getSasState(context).transitToNext(nextEnvState, nextArchConf);
        LOGGER.info((Object)String.format("Transitioned to next state '%s'", nextState.toString()));
        return nextState;
    }

    private PerceivableEnvironmentalState<V> getLastEnvironmentalState(StateSpaceNavigator.NavigationContext<A> context) {
        return this.getSasState(context).getPerceivedEnvironmentalState();
    }

    private ArchitecturalConfiguration<C, A> getLastArchitecturalConfig(StateSpaceNavigator.NavigationContext<A> context) {
        return this.getSasState(context).getArchitecturalConfiguration();
    }

    private SelfAdaptiveSystemState<C, A, V> getSasState(StateSpaceNavigator.NavigationContext<A> context) {
        return (SelfAdaptiveSystemState)context.getSource();
    }

    @Override
    protected PerceivableEnvironmentalState<V> determineInitial(ArchitecturalConfiguration<C, A> initialArch) {
        return this.environmentalDynamics.determineInitial();
    }
}

