/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.core.statespace;

import java.util.Optional;
import org.apache.log4j.Logger;
import org.palladiosimulator.simexp.core.action.Reconfiguration;
import org.palladiosimulator.simexp.core.entity.SimulatedExperience;
import org.palladiosimulator.simexp.core.state.ArchitecturalConfiguration;
import org.palladiosimulator.simexp.core.state.SelfAdaptiveSystemState;
import org.palladiosimulator.simexp.core.state.SimulationRunnerHolder;
import org.palladiosimulator.simexp.core.store.SimulatedExperienceStore;
import org.palladiosimulator.simexp.distribution.function.ProbabilityMassFunction;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivableEnvironmentalState;
import org.palladiosimulator.simexp.environmentaldynamics.process.EnvironmentProcess;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.markovian.statespace.InductiveStateSpaceNavigator;
import org.palladiosimulator.simexp.markovian.statespace.StateSpaceNavigator;
import tools.mdsd.probdist.api.random.ISeedProvider;

public abstract class SelfAdaptiveSystemStateSpaceNavigator<C, A, R, V>
extends InductiveStateSpaceNavigator<A> {
    private static final Logger LOGGER = Logger.getLogger(SelfAdaptiveSystemStateSpaceNavigator.class);
    protected final EnvironmentProcess<A, R, V> environmentalDynamics;
    private final SimulatedExperienceStore<A, R> simulatedExperienceStore;
    private final SimulationRunnerHolder simulationRunnerHolder;

    protected SelfAdaptiveSystemStateSpaceNavigator(EnvironmentProcess<A, R, V> environmentalDynamics, SimulatedExperienceStore<A, R> simulatedExperienceStore, SimulationRunnerHolder simulationRunnerHolder) {
        this.environmentalDynamics = environmentalDynamics;
        this.simulatedExperienceStore = simulatedExperienceStore;
        this.simulationRunnerHolder = simulationRunnerHolder;
    }

    public ProbabilityMassFunction<State> createInitialDistribution(final InitialSelfAdaptiveSystemStateCreator<C, A, V> sassCreator) {
        return new ProbabilityMassFunction<State>(){
            private boolean initialized = false;

            public void init(Optional<ISeedProvider> seedProvider) {
                this.initialized = true;
            }

            public ProbabilityMassFunction.Sample<State> drawSample() {
                if (!this.initialized) {
                    throw new RuntimeException("not initialized");
                }
                ArchitecturalConfiguration initialArch = sassCreator.getInitialArchitecturalConfiguration();
                PerceivableEnvironmentalState initialEnv = SelfAdaptiveSystemStateSpaceNavigator.this.determineInitial(initialArch);
                SelfAdaptiveSystemState create = sassCreator.create(initialArch, initialEnv);
                return ProbabilityMassFunction.Sample.of(create);
            }

            public double probability(ProbabilityMassFunction.Sample<State> sample) {
                return 0.0;
            }
        };
    }

    public State navigate(StateSpaceNavigator.NavigationContext<A> context) {
        NavigationContextValidator checkContext = new NavigationContextValidator();
        try {
            checkContext.validate(context);
        }
        catch (NavigationContextValidator.NavigationContextValidationExcpetion e) {
            throw new RuntimeException(e);
        }
        SelfAdaptiveSystemState<C, A, V> structuralState = this.determineStructuralState(context);
        return this.determineQuantifiedState(structuralState);
    }

    private SelfAdaptiveSystemState<C, A, V> determineQuantifiedState(SelfAdaptiveSystemState<C, A, V> structuralState) {
        Optional<SimulatedExperience> result = this.simulatedExperienceStore.findSelfAdaptiveSystemState(structuralState.toString());
        if (result.isPresent()) {
            LOGGER.info((Object)String.format("cache hit for state: %s -> re-use existing measuremnt", structuralState.toString()));
        }
        structuralState.determineQuantifiedState();
        return structuralState;
    }

    protected abstract SelfAdaptiveSystemState<C, A, V> determineStructuralState(StateSpaceNavigator.NavigationContext<A> var1);

    protected abstract PerceivableEnvironmentalState<V> determineInitial(ArchitecturalConfiguration<C, A> var1);

    public static interface InitialSelfAdaptiveSystemStateCreator<C, A, V> {
        public SelfAdaptiveSystemState<C, A, V> create(ArchitecturalConfiguration<C, A> var1, PerceivableEnvironmentalState<V> var2);

        public ArchitecturalConfiguration<C, A> getInitialArchitecturalConfiguration();
    }

    private class NavigationContextValidator {
        private NavigationContextValidator() {
        }

        public void validate(StateSpaceNavigator.NavigationContext<A> context) throws NavigationContextValidationExcpetion {
            boolean isValid = true;
            StringBuilder invalidContxtMsg = new StringBuilder("Context is invalid. Reason: ");
            Optional action = context.getAction();
            if (!action.isPresent()) {
                invalidContxtMsg.append("no action present");
                isValid = false;
            } else if (!(action.get() instanceof Reconfiguration)) {
                invalidContxtMsg.append("specified action does not conform to reconfiguration specification");
                isValid = false;
            } else if (!(context.getSource() instanceof SelfAdaptiveSystemState)) {
                invalidContxtMsg.append("specified state does not conform to self-adaptive system state specification");
                isValid = false;
            }
            if (!isValid) {
                throw new NavigationContextValidationExcpetion(invalidContxtMsg.toString());
            }
        }

        public static class NavigationContextValidationExcpetion
        extends Exception {
            private static final long serialVersionUID = 1L;

            public NavigationContextValidationExcpetion(String message) {
                super(message);
            }
        }
    }
}

