/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.core.valuefunction;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.palladiosimulator.simexp.core.entity.DefaultSimulatedExperience;
import org.palladiosimulator.simexp.core.entity.SimulatedExperience;
import org.palladiosimulator.simexp.core.evaluation.SampleModelIterator;
import org.palladiosimulator.simexp.core.valuefunction.ValueFunction;
import org.palladiosimulator.simexp.core.valuefunction.ValueFunctionEstimator;

public class MonteCarloPrediction
implements ValueFunctionEstimator {
    private final ValueFunction valueFunction = new ValueFunction();
    private final AccumulatedRewardManager accRewardManager = new AccumulatedRewardManager();
    private MonteCarloEstimator predictionEstimator;

    private MonteCarloPrediction() {
    }

    public static MonteCarloPrediction firstVisitEstimation() {
        MonteCarloPrediction estimation = new MonteCarloPrediction();
        estimation.predictionEstimator = estimation.firstVisitEstimator();
        return estimation;
    }

    @Override
    public ValueFunction estimate(SampleModelIterator iterator) {
        while (iterator.hasNext()) {
            Object traj = iterator.next();
            this.predictionEstimator.estimate((List<SimulatedExperience>)traj);
        }
        return this.valueFunction;
    }

    private MonteCarloEstimator firstVisitEstimator() {
        return new MonteCarloEstimator(){

            @Override
            public void estimate(List<SimulatedExperience> traj) {
                double accReward = 0.0;
                int t = traj.size() - 1;
                while (t >= 0) {
                    List<String> predecessors;
                    SimulatedExperience sample = traj.get(t);
                    accReward += Double.parseDouble(sample.getReward());
                    String current = DefaultSimulatedExperience.getCurrentStateFrom(sample);
                    if (this.isNotIncluded(current, predecessors = traj.subList(0, t).stream().map(each -> DefaultSimulatedExperience.getCurrentStateFrom(each)).collect(Collectors.toList()))) {
                        MonteCarloPrediction.this.accRewardManager.append(current, accReward);
                        double expectedReward = MonteCarloPrediction.this.accRewardManager.getAccumulatedRewardFor(current);
                        MonteCarloPrediction.this.valueFunction.updateExpectedReward(current, expectedReward);
                    }
                    --t;
                }
            }

            private boolean isNotIncluded(String current, List<String> predecessors) {
                return predecessors.stream().noneMatch(each -> each.equals(current));
            }
        };
    }

    private static class AccumulatedRewardManager {
        private final Map<String, List<Double>> managedAccRewards = Maps.newHashMap();

        private AccumulatedRewardManager() {
        }

        public void append(String state, Double accReward) {
            List<Double> accRewards = this.managedAccRewards.get(state);
            if (accRewards == null) {
                this.managedAccRewards.put(state, Lists.newArrayList((Object[])new Double[]{accReward}));
            } else {
                accRewards.add(accReward);
            }
        }

        public Double getAccumulatedRewardFor(String state) {
            List<Double> accRewards = this.managedAccRewards.get(state);
            if (accRewards == null) {
                return 0.0;
            }
            return accRewards.stream().mapToDouble(a -> a).average().getAsDouble();
        }
    }

    private static interface MonteCarloEstimator {
        public void estimate(List<SimulatedExperience> var1);
    }
}

