/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.core.entity;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurementSpecification;

public class SimulatedMeasurement {
    protected static final String VALUE_TAG = "value";
    protected static final String SPEC_TAG = "spec";
    private final SimulatedMeasurementSpecification specification;
    private double value;

    private SimulatedMeasurement(double value, SimulatedMeasurementSpecification specification) {
        this.value = value;
        this.specification = specification;
    }

    public static SimulatedMeasurement of(double value, SimulatedMeasurementSpecification specification) {
        return new SimulatedMeasurement(value, specification);
    }

    public static SimulatedMeasurement with(SimulatedMeasurementSpecification specification) {
        return new SimulatedMeasurement(Double.POSITIVE_INFINITY, specification);
    }

    public void setValue(double value) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public SimulatedMeasurementSpecification getSpecification() {
        return this.specification;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SimulatedMeasurement rhs = (SimulatedMeasurement)obj;
        return new EqualsBuilder().append((Object)this.specification, (Object)rhs.specification).append(this.value, rhs.value).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(15, 37).append((Object)this.specification).append(this.value).toHashCode();
    }

    public String toString() {
        return String.format("{%1s: %2s, %3s: %4s}", VALUE_TAG, this.getValue(), SPEC_TAG, this.getSpecification());
    }
}

