/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.core.evaluation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.palladiosimulator.simexp.core.entity.SimulatedExperience;
import org.palladiosimulator.simexp.core.evaluation.SampleModelIterator;
import org.palladiosimulator.simexp.core.evaluation.TotalRewardCalculation;

public class PerformabilityEvaluator
implements TotalRewardCalculation {
    private static final Logger LOGGER = Logger.getLogger((String)PerformabilityEvaluator.class.getName());
    private final String simulationId;
    private final String sampleSpaceId;

    public PerformabilityEvaluator(String simulationId, String sampleSpaceId) {
        this.simulationId = simulationId;
        this.sampleSpaceId = sampleSpaceId;
    }

    public static TotalRewardCalculation of(String simulationId, String sampleSpaceId) {
        return new PerformabilityEvaluator(simulationId, sampleSpaceId);
    }

    @Override
    public double computeTotalReward() {
        double totalReward = 0.0;
        ArrayList<Double> responseTimes = new ArrayList<Double>();
        SampleModelIterator iterator = SampleModelIterator.get(this.simulationId, this.sampleSpaceId);
        while (iterator.hasNext()) {
            Iterator iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                SimulatedExperience exp = (SimulatedExperience)iterator2.next();
                double responseTime = this.retrieveResponseTime(exp);
                responseTimes.add(responseTime);
            }
        }
        if (!responseTimes.isEmpty()) {
            double addedUpResponseTimes = responseTimes.stream().mapToDouble(Double::doubleValue).sum();
            totalReward = addedUpResponseTimes / (double)responseTimes.size();
        }
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "Computed performability reward: expectation(response time): %.5f", totalReward));
        return totalReward;
    }

    private double retrieveResponseTime(SimulatedExperience exp) {
        String reward = exp.getReward();
        return Double.parseDouble(reward);
    }
}

