/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.core.evaluation;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.palladiosimulator.simexp.core.entity.SimulatedExperience;
import org.palladiosimulator.simexp.core.store.SimulatedExperienceAccessor;
import org.palladiosimulator.simexp.core.store.SimulatedExperienceStoreDescription;
import org.palladiosimulator.simexp.service.registry.ServiceRegistry;

public class SampleModelIterator
implements Iterator<List<SimulatedExperience>> {
    private final SimulatedExperienceAccessor accessor = (SimulatedExperienceAccessor)ServiceRegistry.get().findService(SimulatedExperienceAccessor.class).orElseThrow(() -> new RuntimeException(""));
    private int iteration;

    private SampleModelIterator(SimulatedExperienceStoreDescription desc) {
        this.accessor.connect(desc);
        this.iteration = 0;
    }

    public static SampleModelIterator get(String simulationId, String sampleSpaceId) {
        SimulatedExperienceStoreDescription desc = SimulatedExperienceStoreDescription.newBuilder().withSimulationId(simulationId).andSampleSpaceId(sampleSpaceId).build();
        return new SampleModelIterator(desc);
    }

    @Override
    public boolean hasNext() {
        return this.accessor.getTrajectoryAt(this.iteration).isPresent();
    }

    @Override
    public List<SimulatedExperience> next() {
        if (!this.hasNext()) {
            throw new RuntimeException("");
        }
        Optional<List<SimulatedExperience>> traj = this.accessor.getTrajectoryAt(this.iteration);
        ++this.iteration;
        return traj.get();
    }

    public void terminate() {
        this.accessor.close();
    }
}

