/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.core.evaluation;

import java.util.stream.Stream;
import org.palladiosimulator.simexp.core.entity.SimulatedExperience;
import org.palladiosimulator.simexp.core.evaluation.SampleModelIterator;
import org.palladiosimulator.simexp.core.evaluation.TotalRewardCalculation;

public class SimulatedExperienceEvaluator
implements TotalRewardCalculation {
    private final String simulationId;
    private final String sampleSpaceId;

    private SimulatedExperienceEvaluator(String simulationId, String sampleSpaceId) {
        this.simulationId = simulationId;
        this.sampleSpaceId = sampleSpaceId;
    }

    public static TotalRewardCalculation of(String simulationId, String sampleSpaceId) {
        return new SimulatedExperienceEvaluator(simulationId, sampleSpaceId);
    }

    @Override
    public double computeTotalReward() {
        double totalReward = 0.0;
        SampleModelIterator iterator = SampleModelIterator.get(this.simulationId, this.sampleSpaceId);
        while (iterator.hasNext()) {
            Object traj = iterator.next();
            totalReward += this.accumulateReward(traj.stream());
        }
        return totalReward;
    }

    private double accumulateReward(Stream<SimulatedExperience> traj) {
        return traj.map(each -> Double.parseDouble(each.getReward())).reduce((r1, r2) -> r1 + r2).get();
    }
}

