/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.core.process;

import org.apache.log4j.Logger;
import org.palladiosimulator.simexp.core.process.ExperienceSimulationRunner;
import org.palladiosimulator.simexp.core.process.Initializable;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;

public abstract class AbstractExperienceSimulationRunner<A>
implements ExperienceSimulationRunner,
Initializable {
    protected static final Logger LOGGER = Logger.getLogger(ExperienceSimulationRunner.class);

    @Override
    public void initialize() {
        LOGGER.info((Object)"Initialize experience simulator");
        this.doInitialize();
        LOGGER.info((Object)"Initialized experience simulator");
    }

    @Override
    public final void simulate(State state) {
        LOGGER.info((Object)String.format("Execute pre-simulation hook for state '%s'", state.toString()));
        this.preSimulate(state);
        LOGGER.info((Object)String.format("Executed pre-simulation hook for state '%s'", state.toString()));
        LOGGER.info((Object)String.format("Do simulation for state '%s'", state.toString()));
        this.doSimulate(state);
        LOGGER.info((Object)String.format("Done simulation for state '%s'", state.toString()));
        LOGGER.info((Object)String.format("Execute post-simulation hook for state '%s'", state.toString()));
        this.postSimulate(state);
        LOGGER.info((Object)String.format("Executed post-simulation hook for state '%s'", state.toString()));
    }

    protected void preSimulate(State state) {
    }

    protected abstract void doSimulate(State var1);

    protected void postSimulate(State state) {
    }

    protected void doInitialize() {
    }
}

