/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.core.strategy;

import java.util.Set;
import org.apache.log4j.Logger;
import org.palladiosimulator.simexp.core.action.Reconfiguration;
import org.palladiosimulator.simexp.core.strategy.SharedKnowledge;
import org.palladiosimulator.simexp.markovian.activity.Policy;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.markovian.sampling.SampleDumper;

public abstract class ReconfigurationStrategy<A, Aa extends Reconfiguration<A>>
implements Policy<A, Aa> {
    protected static final Logger LOGGER = Logger.getLogger(ReconfigurationStrategy.class);
    private final SharedKnowledge knowledge = new SharedKnowledge();
    private final SampleDumper sampleDumper;

    public ReconfigurationStrategy(SampleDumper sampleDumper) {
        this.sampleDumper = sampleDumper;
    }

    public Aa select(State source, Set<Aa> options) {
        Aa reconfiguration = this.emptyReconfiguration();
        LOGGER.info((Object)"==== Start MAPE-K loop ====");
        LOGGER.info((Object)"'MONITOR' step start");
        if (this.sampleDumper != null) {
            this.sampleDumper.dump(source);
        }
        this.monitor(source, this.knowledge);
        LOGGER.debug((Object)String.format("'MONITOR' knowledge snapshot: %s", this.knowledge.toString()));
        LOGGER.info((Object)"'MONITOR' step done");
        LOGGER.info((Object)"'ANALYZE' step start");
        boolean isAnalyzable = this.analyse(source, this.knowledge);
        LOGGER.info((Object)String.format("'ANALYZE' found constraint violations: '%s'", isAnalyzable));
        LOGGER.info((Object)"'ANALYZE' step done");
        if (isAnalyzable) {
            LOGGER.info((Object)"'PLANNING' step start");
            reconfiguration = this.plan(source, options, this.knowledge);
            LOGGER.info((Object)String.format("'PLANNING' selected action '%s'", reconfiguration));
            LOGGER.info((Object)"'PLANNING' step done");
        }
        LOGGER.info((Object)"'EXECUTE' step start");
        return reconfiguration;
    }

    protected abstract void monitor(State var1, SharedKnowledge var2);

    protected abstract boolean analyse(State var1, SharedKnowledge var2);

    protected abstract Aa plan(State var1, Set<Aa> var2, SharedKnowledge var3);

    protected abstract Aa emptyReconfiguration();
}

