/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.distribution.apache.factory;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.palladiosimulator.simexp.distribution.apache.function.NormalDistributionAdapter;
import org.palladiosimulator.simexp.distribution.apache.function.SimpleProbabilityMassFunction;
import org.palladiosimulator.simexp.distribution.factory.ProbabilityDistributionFactory;
import org.palladiosimulator.simexp.distribution.function.ProbabilityDensityFunction;
import org.palladiosimulator.simexp.distribution.function.ProbabilityMassFunction;

public class ProbabilityDistributionFactoryAdapter<S>
implements ProbabilityDistributionFactory<S> {
    public ProbabilityMassFunction<S> pmfOver(ProbabilityMassFunction.Sample<S> ... samples) {
        return this.pmfOver(new LinkedHashSet<ProbabilityMassFunction.Sample<S>>(Arrays.asList(samples)));
    }

    public ProbabilityMassFunction<S> pmfOver(Set<ProbabilityMassFunction.Sample<S>> samples) {
        return new SimpleProbabilityMassFunction<S>(samples);
    }

    public ProbabilityMassFunction<S> uniformPmfOver(Set<S> values) {
        return new SimpleProbabilityMassFunction<S>(this.asUniformSampleSpace(values));
    }

    public ProbabilityDensityFunction normalDistributionWith(double mean, double variance) {
        return new NormalDistributionAdapter(mean, Math.sqrt(variance));
    }

    private Set<ProbabilityMassFunction.Sample<S>> asUniformSampleSpace(Set<S> values) {
        int spaceSize = values.size();
        return values.stream().map(each -> ProbabilityMassFunction.Sample.of((Object)each, (double)(1 / spaceSize))).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

