/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.distribution.apache.function;

import java.util.Optional;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.palladiosimulator.simexp.distribution.function.ProbabilityDensityFunction;
import tools.mdsd.probdist.api.random.ISeedProvider;

public class NormalDistributionAdapter
implements ProbabilityDensityFunction {
    private final NormalDistribution normalDistribution;
    private boolean initialized = false;

    public NormalDistributionAdapter(double mean, double sd) {
        this.normalDistribution = new NormalDistribution(mean, sd);
    }

    public void init(Optional<ISeedProvider> seedProvider) {
        this.initialized = true;
        seedProvider.ifPresent(sp -> this.normalDistribution.reseedRandomGenerator(sp.getLong()));
    }

    public Double drawSample() {
        if (!this.initialized) {
            throw new RuntimeException("not initialized");
        }
        return this.normalDistribution.sample();
    }

    public double density(double value) {
        return this.normalDistribution.density(value);
    }
}

