/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.distribution.apache.function;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.math3.distribution.EnumeratedDistribution;
import org.apache.commons.math3.util.Pair;
import org.palladiosimulator.simexp.distribution.function.ProbabilityMassFunction;
import tools.mdsd.probdist.api.random.ISeedProvider;

public class SimpleProbabilityMassFunction<S>
implements ProbabilityMassFunction<S> {
    private static final double DEFAULT_VALUE = 0.0;
    EnumeratedDistribution<ProbabilityMassFunction.Sample<S>> enumDistribution;
    private boolean initialized = false;

    public SimpleProbabilityMassFunction(Set<ProbabilityMassFunction.Sample<S>> samples) {
        this.enumDistribution = new EnumeratedDistribution(this.asPairs(samples));
    }

    private List<Pair<ProbabilityMassFunction.Sample<S>, Double>> asPairs(Set<ProbabilityMassFunction.Sample<S>> samples) {
        return samples.stream().map(each -> Pair.create((Object)each, (Object)each.getProbability())).collect(Collectors.toList());
    }

    public void init(Optional<ISeedProvider> seedProvider) {
        this.initialized = true;
        seedProvider.ifPresent(sp -> this.enumDistribution.reseedRandomGenerator(sp.getLong()));
    }

    public ProbabilityMassFunction.Sample<S> drawSample() {
        if (!this.initialized) {
            throw new RuntimeException("not initialized");
        }
        return (ProbabilityMassFunction.Sample)this.enumDistribution.sample();
    }

    public double probability(ProbabilityMassFunction.Sample<S> sample) {
        return this.findSample(sample).orElse(0.0);
    }

    private Optional<Double> findSample(ProbabilityMassFunction.Sample<S> sample) {
        return this.enumDistribution.getPmf().stream().filter(p -> ((ProbabilityMassFunction.Sample)p.getKey()).equals((Object)sample)).map(p -> (Double)p.getValue()).findFirst();
    }
}

