/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.environmentaldynamics.entity;

import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Vector;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivedValue;

public class PerceivedVectorValue
implements PerceivedValue<Vector<Double>> {
    private final LinkedHashMap<String, Double> vectorElements;

    public PerceivedVectorValue(LinkedHashMap<String, Double> vectorElements) {
        this.vectorElements = vectorElements;
    }

    @Override
    public Vector<Double> getValue() {
        return new Vector<Double>(this.vectorElements.values());
    }

    public Optional<Double> getElement(int index) {
        if (index < 0 || index >= this.vectorElements.size()) {
            return Optional.empty();
        }
        return Optional.of(this.getElementAt(index));
    }

    public double getElementAt(int index) {
        return (Double)this.vectorElements.values().toArray()[index];
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String each : this.vectorElements.keySet()) {
            builder.append(String.format("[%1s: %2s]\n", each, this.vectorElements.get(each)));
        }
        builder.deleteCharAt(builder.lastIndexOf("\n"));
        return builder.toString();
    }
}

