/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.environmentaldynamics.entity;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundRandomVariable;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivedElement;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivedInputValues;
import tools.mdsd.probdist.api.entity.CategoricalValue;

public class PerceivedSelectedInputValues
extends PerceivedInputValues
implements PerceivedElement<List<InputValue<CategoricalValue>>> {
    private final Map<String, InputValue<CategoricalValue>> valueStore;

    public PerceivedSelectedInputValues(List<InputValue<CategoricalValue>> sample, Map<String, String> attributeMap) {
        super(sample);
        this.valueStore = this.buildValueStore(sample, attributeMap);
    }

    private Map<String, InputValue<CategoricalValue>> buildValueStore(List<InputValue<CategoricalValue>> sample, Map<String, String> attributeMap) {
        HashMap<String, InputValue<CategoricalValue>> store = new HashMap<String, InputValue<CategoricalValue>>();
        for (Map.Entry<String, String> entry : attributeMap.entrySet()) {
            store.put(entry.getKey(), this.findInputValue(sample, entry.getValue()));
        }
        return store;
    }

    private InputValue<CategoricalValue> findInputValue(List<InputValue<CategoricalValue>> sample, String variableName) {
        Predicate<InputValue<CategoricalValue>> inputValue = this.inputValue(variableName);
        return sample.stream().filter(inputValue).findFirst().orElseThrow(() -> new RuntimeException(String.format("Variable not found in sample | variableName: '%s' | sample: %s ", variableName, StringUtils.join((Iterable)sample, (String)","))));
    }

    private Predicate<InputValue<CategoricalValue>> inputValue(String variableName) {
        return inputValue -> {
            GroundRandomVariable groundRandomVariabe = inputValue.getVariable();
            String groundRandomVariableName = groundRandomVariabe.getEntityName();
            return groundRandomVariableName.equals(variableName);
        };
    }

    @Override
    public List<InputValue<CategoricalValue>> getValue() {
        return this.valueStore.values().stream().map(InputValue.class::cast).collect(Collectors.toList());
    }

    @Override
    public Optional<List<InputValue<CategoricalValue>>> getElement(String key) {
        InputValue<CategoricalValue> value = this.valueStore.get(key);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(Collections.singletonList(value));
    }
}

