/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.environmentaldynamics.entity;

import java.util.Objects;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivableEnvironmentalState;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivedValue;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.impl.StateImpl;

public class EnvironmentalState<V>
extends StateImpl
implements PerceivableEnvironmentalState<V> {
    private final PerceivedValue<V> value;
    private final boolean isInitial;
    private final boolean isHidden;

    protected EnvironmentalState(PerceivedValue<V> value, boolean isInitial, boolean isHidden) {
        this.value = value;
        this.isInitial = isInitial;
        this.isHidden = isHidden;
    }

    public static <V> EnvironmentalStateBuilder<V> newBuilder() {
        return new EnvironmentalStateBuilder();
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    @Override
    public PerceivedValue<V> getValue() {
        return this.value;
    }

    @Override
    public boolean isInitial() {
        return this.isInitial;
    }

    public static class EnvironmentalStateBuilder<V> {
        private PerceivedValue<V> value = null;
        private boolean isInitial = false;
        private boolean isHidden = false;

        public EnvironmentalStateBuilder<V> withValue(PerceivedValue<V> value) {
            this.value = value;
            return this;
        }

        public EnvironmentalStateBuilder<V> isInital() {
            this.isInitial = true;
            return this;
        }

        public EnvironmentalStateBuilder<V> isHidden() {
            this.isHidden = true;
            return this;
        }

        public EnvironmentalState<V> build() {
            Objects.requireNonNull(this.value, "The environmental state value must not be null");
            return new EnvironmentalState<V>(this.value, this.isInitial, this.isHidden);
        }
    }
}

