/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.environmentaldynamics.entity;

import java.util.Objects;
import org.palladiosimulator.simexp.environmentaldynamics.entity.DerivableEnvironmentalDynamic;
import org.palladiosimulator.simexp.environmentaldynamics.entity.DescribableEnvironmentalDynamic;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.Action;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.MarkovModel;
import org.palladiosimulator.simexp.markovian.statespace.StateSpaceNavigator;

public interface EnvironmentalDynamic {
    public static <A, Aa extends Action<A>, R> EnvironmentalDynamicBuilder<A, Aa, R> describedBy(MarkovModel<A, R> model) {
        return new EnvironmentalDynamicBuilder(model);
    }

    public static <A, Aa extends Action<A>, R> EnvironmentalDynamicBuilder<A, Aa, R> derivedBy(MarkovModel<A, R> model) {
        return new EnvironmentalDynamicBuilder(model);
    }

    public boolean isHiddenProcess();

    public static class EnvironmentalDynamicBuilder<A, Aa extends Action<A>, R> {
        private MarkovModel<A, R> model = null;
        private DerivableEnvironmentalDynamic<A> dynamic = null;
        private boolean exploration = false;
        private boolean isHiddenProcess = false;

        private EnvironmentalDynamicBuilder(MarkovModel<A, R> model) {
            this.model = model;
        }

        private EnvironmentalDynamicBuilder(DerivableEnvironmentalDynamic<A> dynamic) {
            this.dynamic = dynamic;
        }

        public EnvironmentalDynamicBuilder<A, Aa, R> asExplorationProcess() {
            this.exploration = true;
            return this;
        }

        public EnvironmentalDynamicBuilder<A, Aa, R> asExploitationProcess() {
            this.exploration = false;
            return this;
        }

        public EnvironmentalDynamicBuilder<A, Aa, R> isHiddenProcess() {
            this.isHiddenProcess = true;
            return this;
        }

        public EnvironmentalDynamic build() {
            StateSpaceNavigator<A> navigator = this.model != null ? this.initDescribable(this.exploration) : this.initDerivable(this.exploration);
            return (EnvironmentalDynamic)EnvironmentalDynamic.class.cast(navigator);
        }

        private StateSpaceNavigator<A> initDerivable(boolean isExploration) {
            Objects.requireNonNull(this.dynamic, "The environemtal dynamic must not be null.");
            this.dynamic.isHiddenProcess = this.isHiddenProcess;
            if (isExploration) {
                this.dynamic.pursueExplorationStrategy();
            } else {
                this.dynamic.pursueExploitationStrategy();
            }
            return this.dynamic;
        }

        private StateSpaceNavigator<A> initDescribable(boolean isExploration) {
            DescribableEnvironmentalDynamic navigator = new DescribableEnvironmentalDynamic(this.model, this.isHiddenProcess, isExploration);
            return navigator;
        }
    }
}

