/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.environmentaldynamics.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivedValue;
import tools.mdsd.probdist.api.entity.CategoricalValue;

public class PerceivedInputValues
implements PerceivedValue<List<InputValue<CategoricalValue>>> {
    private final List<InputValue<CategoricalValue>> samples;

    public PerceivedInputValues(List<InputValue<CategoricalValue>> samples) {
        this.samples = samples;
    }

    @Override
    public List<InputValue<CategoricalValue>> getValue() {
        return this.samples;
    }

    private List<InputValue<CategoricalValue>> getSortedSamples() {
        ArrayList orderedSamples = Lists.newArrayList(this.samples);
        Collections.sort(orderedSamples, new Comparator<InputValue<CategoricalValue>>(){

            @Override
            public int compare(InputValue<CategoricalValue> i1, InputValue<CategoricalValue> i2) {
                return i1.getVariable().getEntityName().compareTo(i2.getVariable().getEntityName());
            }
        });
        return orderedSamples;
    }

    public String toString() {
        ArrayList<String> entries = new ArrayList<String>();
        for (InputValue<CategoricalValue> each : this.getSortedSamples()) {
            entries.add(String.format("(Variable: %1s, Value: %2s)", each.getVariable().getEntityName(), ((CategoricalValue)each.getValue()).toString()));
        }
        return String.format("Samples: [%s])", StringUtils.join(entries, (String)","));
    }
}

