/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.markovian.model.factory;

import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.MarkovEntityFactory;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.Observation;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.Reward;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.Transition;

public class MarkovModelFactory {
    private final MarkovEntityFactory entityFactory = MarkovEntityFactory.eINSTANCE;

    public State createState(String name) {
        State newState = this.entityFactory.createState();
        newState.setName(name);
        return newState;
    }

    public <A> Transition<A> createTransitionBetween(State source, State target) {
        Transition newTransition = this.entityFactory.createTransition();
        newTransition.setSource(source);
        newTransition.setTarget(target);
        return newTransition;
    }

    public <T> Reward<T> createRewardSignal() {
        return this.entityFactory.createReward();
    }

    public <T> Reward<T> createRewardSignal(T value) {
        Reward<T> reward = this.entityFactory.createReward();
        reward.setValue(value);
        return reward;
    }

    public Observation createObservation() {
        Observation obs = this.entityFactory.createObservation();
        return obs;
    }
}

