/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.markovian.model.builder;

import java.util.Set;
import org.palladiosimulator.simexp.markovian.model.factory.MarkovModelFactory;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.Action;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.MarkovEntityFactory;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.MarkovModel;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.Transition;

public class BasicMarkovModelBuilder<A, R> {
    private final MarkovModelFactory markovModelFactory = new MarkovModelFactory();
    private final MarkovModel<A, R> markovModel = MarkovEntityFactory.eINSTANCE.createMarkovModel();

    public BasicMarkovModelBuilder<A, R> withStateSpace(Set<State> states) {
        this.markovModel.getStateSpace().addAll(states);
        return this;
    }

    public TransitionBuilder andTransitionBetween(State source, State target) {
        return new TransitionBuilder(source, target);
    }

    public MarkovModel<A, R> build() {
        return this.markovModel;
    }

    public class TransitionBuilder {
        private Transition<A> transition;

        public TransitionBuilder(State source, State target) {
            this.transition = BasicMarkovModelBuilder.this.markovModelFactory.createTransitionBetween(source, target);
        }

        public BasicMarkovModelBuilder<A, R> andProbability(double value) {
            this.transition.setProbability(value);
            BasicMarkovModelBuilder.this.markovModel.getTransitions().add(this.transition);
            return BasicMarkovModelBuilder.this;
        }

        public TransitionBuilder withOptionalLabel(Action<A> action) {
            this.transition.setLabel(action);
            return this;
        }
    }
}

