package org.palladiosimulator.simexp.markovian.exploitation;

import java.util.Set;

import org.palladiosimulator.simexp.distribution.factory.ProbabilityDistributionFactory;
import org.palladiosimulator.simexp.distribution.function.ProbabilityMassFunction;
import org.palladiosimulator.simexp.distribution.function.ProbabilityMassFunction.Sample;
import org.palladiosimulator.simexp.markovian.activity.BasePolicy;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.Transition;
import org.palladiosimulator.simexp.markovian.util.MarkovianUtil;

public class ProbabilityBasedTransitionPolicy<A> implements BasePolicy<Transition<A>> {

    private final static String POLICY_NAME = "ProbabilityBasedTransitionSelection";

    @Override
    public Transition<A> select(State source, Set<Transition<A>> options) {
        // ProbabilityMassFunction pmf =
        // ProbabilityDistributionFactory.INSTANCE.pmfOver(toSamples(options));
        // return (Transition) pmf.drawSample().getValue();

        // static <T> Set<ProbabilityMassFunction.Sample<Transition<T, Double>>>
        // toSamples(Set<Transition<T, Double>> transitions) {

        Set<ProbabilityMassFunction.Sample<Transition<A>>> samples = MarkovianUtil.toSamples(options);
        ProbabilityMassFunction<Transition<A>> pmf = ProbabilityDistributionFactory.INSTANCE.pmfOver(samples);
        Sample<Transition<A>> drawSample = pmf.drawSample();
        return drawSample.getValue();
    }

    @Override
    public String getId() {
        return POLICY_NAME;
    }

}
