package org.palladiosimulator.simexp.markovian.exploitation;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;

import org.palladiosimulator.simexp.markovian.access.MarkovModelAccessor;
import org.palladiosimulator.simexp.markovian.activity.Policy;
import org.palladiosimulator.simexp.markovian.exploration.RandomizedStrategy;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.Action;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.MarkovModel;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.Transition;

public class ProbabilityBasedActionPolicy<R> implements Policy<Double, Action<Double>> {

    private final static String POLICY_NAME = "ProbabilityBasedActionSelection";

    private final Optional<MarkovModelAccessor<Double, R>> markovAccessor;

    public ProbabilityBasedActionPolicy(Optional<MarkovModel<Double, R>> markovModel) {
        if (markovModel.isPresent()) {
            MarkovModel<Double, R> model = markovModel.get();
            MarkovModelAccessor<Double, R> accessor = MarkovModelAccessor.of(model);
            this.markovAccessor = Optional.of(accessor);
        } else {
            this.markovAccessor = Optional.empty();
        }
    }

    @Override
    public String getId() {
        return POLICY_NAME;
    }

    @Override
    public Action<Double> select(State source, Set<Action<Double>> options) {
        if (markovAccessor.isPresent()) {
            return selectAccordingToModel(source, options);
        }
        return selectRandomly(options);
    }

    private Action<Double> selectAccordingToModel(State source, Set<Action<Double>> options) {
        ProbabilityBasedTransitionPolicy<Double> probabilityBasedTransitionPolicy = new ProbabilityBasedTransitionPolicy<>();
        Set<Transition<Double>> filterTransitions = filterTransitions(source, options);
        Transition<Double> s = probabilityBasedTransitionPolicy.select(null, filterTransitions);
        Action<Double> label = s.getLabel();
        return label;
    }

    private Set<Transition<Double>> filterTransitions(State source, Set<Action<Double>> options) {
        Set<Transition<Double>> results = new LinkedHashSet<>();
        for (Action<Double> each : options) {
            // TODO exception handling
            MarkovModelAccessor<Double, R> markovModelAccessor = markovAccessor.get();
            Optional<Transition<Double>> transition = markovModelAccessor.findTransition(source, each);
            Transition<Double> result = transition.orElseThrow(() -> new RuntimeException(""));
            results.add(result);
        }
        return results;
    }

    private Action<Double> selectRandomly(Set<Action<Double>> options) {
        return new RandomizedStrategy<Action<Double>>().select(null, options);
    }

}
