/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.markovian.access;

import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.markovian.model.markovmodel.samplemodel.Sample;
import org.palladiosimulator.simexp.markovian.model.markovmodel.samplemodel.SampleModel;
import org.palladiosimulator.simexp.markovian.model.markovmodel.samplemodel.SampleModelFactory;
import org.palladiosimulator.simexp.markovian.model.markovmodel.samplemodel.Trajectory;

public class SampleModelAccessor<A, R> {
    private static final SampleModelFactory sampleModelFactory = SampleModelFactory.eINSTANCE;
    private final SampleModel<A, R> sampleModel;

    public SampleModelAccessor(Optional<SampleModel<A, R>> sampleModel) {
        this.sampleModel = sampleModel.orElse(sampleModelFactory.createSampleModel());
    }

    public void addNewTrajectory(Sample<A, R> initial) {
        Trajectory traj = sampleModelFactory.createTrajectory();
        traj.getSamplePath().add(initial);
        this.sampleModel.getTrajectories().add((Object)traj);
    }

    public Trajectory<A, R> getCurrentTrajectory() {
        int index = this.sampleModel.getTrajectories().size() - 1;
        return (Trajectory)this.sampleModel.getTrajectories().get(index);
    }

    public void addSample(Sample<A, R> sample) {
        this.getCurrentTrajectory().getSamplePath().add(sample);
    }

    public SampleModel<A, R> getSampleModel() {
        return this.sampleModel;
    }

    public Sample<A, R> getCurrentSample() {
        EList samplePath = this.getCurrentTrajectory().getSamplePath();
        return (Sample)samplePath.get(samplePath.size() - 1);
    }

    public Sample<A, R> createTemplateSampleBy(Sample<A, R> ref) {
        if (this.isInitialSample(ref)) {
            return ref;
        }
        return SampleModelAccessor.createSampleBy(ref.getNext(), ref.getPointInTime() + 1);
    }

    private boolean isInitialSample(Sample<A, R> sample) {
        return sample.getPointInTime() == 0 && sample.getNext() == null;
    }

    public static <A, R> Sample<A, R> createSampleBy(State current) {
        Sample newSample = sampleModelFactory.createSample();
        newSample.setCurrent(current);
        return newSample;
    }

    public static <A, R> Sample<A, R> createSampleBy(State current, int pointInTime) {
        Sample<A, R> newSample = SampleModelAccessor.createSampleBy(current);
        newSample.setPointInTime(pointInTime);
        return newSample;
    }

    public static <A, R> Sample<A, R> createInitialSample(State initial) {
        return SampleModelAccessor.createSampleBy(initial, 0);
    }
}

