/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.markovian.evaluation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.palladiosimulator.simexp.distribution.function.ProbabilityMassFunction;
import org.palladiosimulator.simexp.markovian.access.MarkovModelAccessor;
import org.palladiosimulator.simexp.markovian.model.factory.MarkovModelFactory;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.MarkovModel;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.Reward;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.Transition;
import org.palladiosimulator.simexp.markovian.model.markovmodel.samplemodel.Sample;
import org.palladiosimulator.simexp.markovian.model.markovmodel.samplemodel.SampleModel;
import org.palladiosimulator.simexp.markovian.model.markovmodel.samplemodel.Trajectory;
import org.palladiosimulator.simexp.markovian.type.MarkovianResult;

public class SampleModelEvaluator<A> {
    private final TransitionCache<A> transitionCache = new TransitionCache();
    private final MarkovModelAccessor<A, Double> modelAccessor;
    private final ProbabilityMassFunction<State> initialStateDist;

    private SampleModelEvaluator(MarkovModel<A, Double> model, ProbabilityMassFunction<State> initialStateDist) {
        this.modelAccessor = MarkovModelAccessor.of(model);
        this.initialStateDist = initialStateDist;
    }

    public static <A> SampleModelEvaluator<A> of(MarkovModel<A, Double> model, ProbabilityMassFunction<State> initialStateDist) {
        return new SampleModelEvaluator<A>(model, initialStateDist);
    }

    public List<MarkovianResult<A, Double>> evaluate(SampleModel<A, Double> sampleModelToEval) {
        return sampleModelToEval.getTrajectories().stream().map(this::evaluate).collect(Collectors.toList());
    }

    public MarkovianResult<A, Double> evaluate(Trajectory<A, Double> trajToEval) {
        double total = 0.0;
        double probability = this.computeInitial(trajToEval);
        for (Sample each : trajToEval.getSamplePath()) {
            total += ((Double)each.getReward().getValue()).doubleValue();
            probability *= this.getProbability(each);
        }
        Reward totalReward = new MarkovModelFactory().createRewardSignal((Object)total);
        return MarkovianResult.of(trajToEval).withProbability(probability).andReward((Reward<Double>)totalReward).build();
    }

    private double computeInitial(Trajectory<A, Double> trajToEval) {
        Sample sample = (Sample)trajToEval.getSamplePath().get(0);
        State initial = sample.getCurrent();
        ProbabilityMassFunction.Sample of = ProbabilityMassFunction.Sample.of((Object)initial);
        return this.initialStateDist.probability(of);
    }

    private double getProbability(Sample<A, Double> sample) {
        Transition<A> result = this.transitionCache.findTransition(sample).orElse(this.queryMarkovModelAndCacheResult(sample));
        return result.getProbability();
    }

    private Transition<A> queryMarkovModelAndCacheResult(Sample<A, Double> sample) {
        Transition<A> result = this.modelAccessor.findTransition(sample.getCurrent(), sample.getNext()).orElseThrow(() -> new RuntimeException(""));
        this.transitionCache.put(sample, result);
        return result;
    }

    private static class TransitionCache<A> {
        private static final int CACHE_SIZE = 100;
        private final Map<Integer, Transition<A>> cache = new HashMap<Integer, Transition<A>>();

        public Optional<Transition<A>> findTransition(Sample<A, Double> sample) {
            Transition<A> value = this.cache.get(sample.hashCode());
            return Optional.ofNullable(value);
        }

        public void put(Sample<A, Double> sample, Transition<A> transition) {
            if (!this.isCacheFull()) {
                this.cache.put(sample.hashCode(), transition);
            }
        }

        private boolean isCacheFull() {
            return this.cache.size() == 100;
        }
    }
}

