/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.markovian.type;

import org.palladiosimulator.simexp.distribution.function.ProbabilityMassFunction;
import org.palladiosimulator.simexp.markovian.access.SampleModelAccessor;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.markovian.model.markovmodel.samplemodel.Sample;
import org.palladiosimulator.simexp.markovian.statespace.StateSpaceNavigator;
import org.palladiosimulator.simexp.markovian.type.Markovian;

public class BasicMarkovian<A, R>
implements Markovian<A, R> {
    private final ProbabilityMassFunction<State> initialStateDistribution;
    private final StateSpaceNavigator<A> stateSpaceNavigator;

    public BasicMarkovian(ProbabilityMassFunction<State> initialStateDistribution, StateSpaceNavigator<A> stateSpaceNavigator) {
        this.initialStateDistribution = initialStateDistribution;
        this.stateSpaceNavigator = stateSpaceNavigator;
    }

    @Override
    public void drawSample(Sample<A, R> sample) {
        StateSpaceNavigator.NavigationContext<A> context = StateSpaceNavigator.NavigationContext.of(sample);
        sample.setNext(this.stateSpaceNavigator.navigate(context));
    }

    @Override
    public Sample<A, R> determineInitialState() {
        ProbabilityMassFunction.Sample sample = (ProbabilityMassFunction.Sample)this.initialStateDistribution.drawSample();
        State value = (State)sample.getValue();
        return SampleModelAccessor.createInitialSample(value);
    }

    @Override
    public ProbabilityMassFunction<State> getInitialStateDistribution() {
        return this.initialStateDistribution;
    }
}

