/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.markovian.type;

import org.palladiosimulator.simexp.markovian.activity.ObservationProducer;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.Observation;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.markovian.model.markovmodel.samplemodel.Sample;
import org.palladiosimulator.simexp.markovian.type.Markovian;
import org.palladiosimulator.simexp.markovian.type.MarkovianDecorator;

public class HiddenStateMarkovian<A, R>
extends MarkovianDecorator<A, R> {
    private final ObservationProducer obsDistribution;

    public HiddenStateMarkovian(Markovian<A, R> decoratedMarkovian, ObservationProducer obsDistribution) {
        super(decoratedMarkovian);
        this.obsDistribution = obsDistribution;
    }

    @Override
    public void drawSample(Sample<A, R> sample) {
        this.decoratedMarkovian.drawSample(sample);
        this.produceObservation(sample);
    }

    private void produceObservation(Sample<A, R> sample) {
        Observation result = this.obsDistribution.produceObservationGiven(sample.getNext());
        sample.setObservation(result);
    }

    @Override
    public Sample<A, R> determineInitialState() {
        Sample initial = this.decoratedMarkovian.determineInitialState();
        this.produceObservationForInitial(initial);
        return initial;
    }

    private void produceObservationForInitial(Sample<A, R> sample) {
        State currentState = sample.getCurrent();
        Observation result = this.obsDistribution.produceObservationGiven(currentState);
        sample.setObservation(result);
        result.setObserved(currentState);
    }
}

