/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.markovian.util;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.palladiosimulator.simexp.distribution.function.ProbabilityMassFunction;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.Action;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.Transition;

public class MarkovianUtil {
    public static <A> Set<Action<A>> toActions(Set<Transition<A>> transitions) {
        return new TransitionMapper<Transition<A>, Action>(transitions).apply(t -> t.getLabel());
    }

    public static <A> Set<ProbabilityMassFunction.Sample<Transition<A>>> toSamples(Set<Transition<A>> transitions) {
        return new TransitionMapper<Transition<A>, ProbabilityMassFunction.Sample>(transitions).apply(t -> ProbabilityMassFunction.Sample.of((Object)t, (double)t.getProbability()));
    }

    public static <A> Transition<A> maxTransition(Set<Transition<A>> transitions) {
        return (Transition)transitions.stream().max((t1, t2) -> Double.valueOf(t1.getProbability()).compareTo(t2.getProbability())).orElseThrow(() -> new RuntimeException(""));
    }

    private static class TransitionMapper<U, T> {
        private final Set<U> transitions;

        public TransitionMapper(Set<U> transitions) {
            this.transitions = transitions;
        }

        public Set<T> apply(Function<U, T> mapping) {
            return this.transitions.stream().map(mapping).collect(Collectors.toCollection(LinkedHashSet::new));
        }
    }
}

