/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.markovian.access;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.Action;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.MarkovModel;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.Transition;
import org.palladiosimulator.simexp.markovian.util.FilterCriterionUtil;

public class MarkovModelAccessor<A, R> {
    private final MarkovModel<A, R> model;

    private MarkovModelAccessor(MarkovModel<A, R> model) {
        this.model = model;
    }

    public static <A, R> MarkovModelAccessor<A, R> of(MarkovModel<A, R> model) {
        return new MarkovModelAccessor<A, R>(model);
    }

    private Stream<Transition<A>> getTransitionStream() {
        return this.model.getTransitions().stream();
    }

    public Set<State> getStates() {
        return new LinkedHashSet<State>((Collection<State>)this.model.getStateSpace());
    }

    public Set<Transition<A>> filterTransitions(Predicate<Transition<A>> criterion) {
        return this.getTransitionStream().filter(criterion).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Optional<Transition<A>> findTransition(State source, Action<A> label) {
        Predicate<Transition<A>> filterPredicate = FilterCriterionUtil.withSource(source).and(FilterCriterionUtil.withLabel(label));
        return this.getTransitionStream().filter(filterPredicate).findFirst();
    }

    public Optional<Transition<A>> findTransition(State source, State target) {
        return this.getTransitionStream().filter(FilterCriterionUtil.withSource(source).and(FilterCriterionUtil.withTarget(target))).findFirst();
    }
}

