/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.model.strategy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.palladiosimulator.simexp.core.strategy.ReconfigurationStrategy;
import org.palladiosimulator.simexp.core.strategy.SharedKnowledge;
import org.palladiosimulator.simexp.dsl.smodel.interpreter.ResolvedAction;
import org.palladiosimulator.simexp.dsl.smodel.interpreter.mape.Analyzer;
import org.palladiosimulator.simexp.dsl.smodel.interpreter.mape.Monitor;
import org.palladiosimulator.simexp.dsl.smodel.interpreter.mape.Planner;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.markovian.sampling.SampleDumper;
import org.palladiosimulator.simexp.pcm.action.EmptyQVToReconfiguration;
import org.palladiosimulator.simexp.pcm.action.IQVTOModelTransformationSearch;
import org.palladiosimulator.simexp.pcm.action.IQVToReconfigurationManager;
import org.palladiosimulator.simexp.pcm.action.MultiQVToReconfiguration;
import org.palladiosimulator.simexp.pcm.action.ParameterizedSingleQVToReconfiguration;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QvtoModelTransformation;

public class ModelledReconfigurationStrategy
extends ReconfigurationStrategy<QVTOReconfigurator, QVToReconfiguration> {
    private final Monitor monitor;
    private final Analyzer analyzer;
    private final Planner planner;
    private final String strategyId;
    private final IQVToReconfigurationManager qvtoReconfigurationManager;

    public ModelledReconfigurationStrategy(SampleDumper sampleDumper, String strategyId, Monitor monitor, Analyzer analyzer, Planner planner, IQVToReconfigurationManager qvtoReconfigurationManager) {
        super(sampleDumper);
        this.strategyId = strategyId;
        this.monitor = monitor;
        this.analyzer = analyzer;
        this.planner = planner;
        this.qvtoReconfigurationManager = qvtoReconfigurationManager;
    }

    public String getId() {
        return this.strategyId;
    }

    protected void monitor(State source, SharedKnowledge knowledge) {
        this.monitor.monitor(source);
    }

    protected boolean analyse(State source, SharedKnowledge knowledge) {
        return this.analyzer.analyze();
    }

    protected QVToReconfiguration plan(State source, Set<QVToReconfiguration> options, SharedKnowledge knowledge) {
        List resolvedActions = this.planner.plan();
        QVToReconfiguration plannedReconfiguration = this.createReconfiguration(resolvedActions);
        return plannedReconfiguration;
    }

    private QVToReconfiguration createReconfiguration(List<ResolvedAction> actions) {
        ArrayList<ParameterizedSingleQVToReconfiguration> reconfigurations = new ArrayList<ParameterizedSingleQVToReconfiguration>();
        for (ResolvedAction resolvedAction : actions) {
            String resolvedActionName = resolvedAction.getAction().getName();
            IQVTOModelTransformationSearch qvtoModelTransformationSearch = this.qvtoReconfigurationManager.getQVTOModelTransformationSearch();
            QvtoModelTransformation transformation = qvtoModelTransformationSearch.findQvtoModelTransformation(resolvedActionName);
            Map arguments = resolvedAction.getArguments();
            ParameterizedSingleQVToReconfiguration reconfiguration = new ParameterizedSingleQVToReconfiguration(transformation, this.qvtoReconfigurationManager, arguments);
            reconfigurations.add(reconfiguration);
        }
        MultiQVToReconfiguration reconfiguration = MultiQVToReconfiguration.of(reconfigurations);
        return reconfiguration;
    }

    protected QVToReconfiguration emptyReconfiguration() {
        return EmptyQVToReconfiguration.empty();
    }
}

