/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.binding.resourceenvironment;

import java.util.Optional;
import org.apache.log4j.Logger;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivedElement;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivedValue;
import org.palladiosimulator.simexp.pcm.perceiption.PcmModelChange;
import org.palladiosimulator.simexp.pcm.perceiption.PerceivedValueConverter;
import tools.mdsd.probdist.api.entity.CategoricalValue;

public abstract class AbstractPcmModelChange<V>
implements PcmModelChange<V> {
    private static final Logger LOGGER = Logger.getLogger(AbstractPcmModelChange.class);
    private final String pcmAttrbuteName;
    private final PerceivedValueConverter<V> perceivedValueConverter;

    public AbstractPcmModelChange(String pcmAttributeName, PerceivedValueConverter<V> perceivedValueConverter) {
        this.pcmAttrbuteName = pcmAttributeName;
        this.perceivedValueConverter = perceivedValueConverter;
    }

    abstract void applyChange(CategoricalValue var1);

    protected String getPcmAttributeName() {
        return this.pcmAttrbuteName;
    }

    public void apply(PerceivedValue<V> change) {
        PerceivedElement pe = (PerceivedElement)change;
        Optional newValue = pe.getElement(this.pcmAttrbuteName);
        if (newValue.isPresent()) {
            CategoricalValue changedValue = this.perceivedValueConverter.convertElement(change, this.pcmAttrbuteName);
            this.applyChange(changedValue);
            LOGGER.debug((Object)String.format("Applied perceived environmental value '%s' to PCM model element '%s'", changedValue.get(), this.pcmAttrbuteName));
        } else {
            LOGGER.error((Object)String.format("Failed binding: could not apply perceived environmental value '%s' to PCM model element '%s'", change.getValue().toString(), this.pcmAttrbuteName));
        }
    }
}

