/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.binding.resourceenvironment;

import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.failuremodel.failurescenario.FailureScenarioRepository;
import org.palladiosimulator.failuremodel.failurescenario.FailurescenarioPackage;
import org.palladiosimulator.failuremodel.failuretype.FailureTypeRepository;
import org.palladiosimulator.failuremodel.failuretype.FailuretypePackage;
import org.palladiosimulator.failuremodel.failuretype.HWCrashFailure;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.simexp.pcm.binding.resourceenvironment.AbstractPcmModelChange;
import org.palladiosimulator.simexp.pcm.perceiption.PerceivedValueConverter;
import org.palladiosimulator.simexp.pcm.state.failure.NodeFailureStateCreator;
import org.palladiosimulator.simexp.pcm.util.IExperimentProvider;
import tools.mdsd.probdist.api.entity.CategoricalValue;

public class ResourceContainerPcmModelChange<V>
extends AbstractPcmModelChange<V> {
    private static final Logger LOGGER = Logger.getLogger(ResourceContainerPcmModelChange.class);
    private NodeFailureStateCreator failureStateCreator = new NodeFailureStateCreator();
    private final IExperimentProvider experimentProvider;

    public ResourceContainerPcmModelChange(String attributeName, PerceivedValueConverter<V> perceivedValueConverter, IExperimentProvider experimentProvider) {
        super(attributeName, perceivedValueConverter);
        this.experimentProvider = experimentProvider;
    }

    @Override
    void applyChange(CategoricalValue value) {
        if (StringUtils.equals((String)"unavailable", (String)((String)value.get()))) {
            PCMResourceSetPartition pcm = this.experimentProvider.getExperimentRunner().getWorkingPartition();
            EList resourceContainers = pcm.getResourceEnvironment().getResourceContainer_ResourceEnvironment();
            List<ResourceContainer> failedResourceContainers = this.filterFailedResourceContainer((EList<ResourceContainer>)resourceContainers, this.getPcmAttributeName());
            LOGGER.info((Object)String.format("Unavailable server node detected: %s", this.debugMessageFailedServerNodes(failedResourceContainers)));
            ResourceSetPartition plainPartition = this.experimentProvider.getExperimentRunner().getPlainWorkingPartition();
            FailureScenarioRepository failureScenarioRepo = (FailureScenarioRepository)plainPartition.getElement(FailurescenarioPackage.eINSTANCE.getFailureScenarioRepository()).get(0);
            FailureTypeRepository failureTypeRepo = (FailureTypeRepository)plainPartition.getElement(FailuretypePackage.eINSTANCE.getFailureTypeRepository()).get(0);
            HWCrashFailure hwCrashFailureType = (HWCrashFailure)failureTypeRepo.getFailuretypes().get(0);
            this.failureStateCreator.addScenario(failureScenarioRepo, failedResourceContainers, hwCrashFailureType);
            try {
                this.experimentProvider.getExperimentRunner().updateFailureScenario(failureScenarioRepo);
            }
            catch (IOException e) {
                LOGGER.error((Object)"Failed to inject updated failurescenario model into blackboard partition", (Throwable)e);
            }
        }
    }

    private List<ResourceContainer> filterFailedResourceContainer(EList<ResourceContainer> resourceContainers, String filterFailedResourceContainerName) {
        List<ResourceContainer> filteredFailedResourceContainters = resourceContainers.stream().filter(rc -> rc.getEntityName().equals(filterFailedResourceContainerName)).collect(Collectors.toList());
        return filteredFailedResourceContainters;
    }

    private String debugMessageFailedServerNodes(List<ResourceContainer> resourceContainers) {
        StringBuilder sb = new StringBuilder();
        sb.append("Failed resource container(s) [");
        for (ResourceContainer resourceContainer : resourceContainers) {
            sb.append("(");
            sb.append(resourceContainer.getId());
            sb.append(",");
            sb.append(resourceContainer.getEntityName());
            sb.append("),");
        }
        sb.append("]");
        return sb.toString();
    }
}

