/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot;

import java.util.Optional;
import org.palladiosimulator.core.simulation.SimulationExecutor;
import org.palladiosimulator.simexp.commons.constants.model.SimulationEngine;
import org.palladiosimulator.simexp.commons.constants.model.SimulatorType;
import org.palladiosimulator.simexp.core.store.DescriptionProvider;
import org.palladiosimulator.simexp.core.store.SimulatedExperienceStore;
import org.palladiosimulator.simexp.pcm.config.IPrismWorkflowConfiguration;
import org.palladiosimulator.simexp.pcm.config.IWorkflowConfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.DeltaIoTSimulationExecutorFactory;
import org.palladiosimulator.simexp.pcm.examples.executor.ModelLoader;
import org.palladiosimulator.simexp.workflow.api.ILaunchFactory;
import org.palladiosimulator.simexp.workflow.api.LaunchDescriptionProvider;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import tools.mdsd.probdist.api.random.ISeedProvider;

public class CustomPrismSimulationExecutorLaunchFactory
implements ILaunchFactory {
    public boolean canHandle(IWorkflowConfiguration config) {
        SimulatorType simulatorType = config.getSimulatorType();
        if (simulatorType != SimulatorType.CUSTOM) {
            return false;
        }
        SimulationEngine simulationEngine = config.getSimulationEngine();
        return simulationEngine == SimulationEngine.PRISM;
    }

    public SimulationExecutor createSimulationExecutor(IWorkflowConfiguration config, LaunchDescriptionProvider descriptionProvider, Optional<ISeedProvider> seedProvider, ModelLoader.Factory modelLoaderFactory) {
        IPrismWorkflowConfiguration workflowConfiguration = (IPrismWorkflowConfiguration)config;
        DeltaIoTSimulationExecutorFactory factory = new DeltaIoTSimulationExecutorFactory(workflowConfiguration, modelLoaderFactory, (SimulatedExperienceStore<QVTOReconfigurator, Double>)new SimulatedExperienceStore((DescriptionProvider)descriptionProvider), seedProvider);
        return factory.create();
    }
}

