/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.naming.OperationNotSupportedException;
import org.apache.log4j.Logger;
import org.palladiosimulator.envdyn.api.entity.bn.BayesianNetwork;
import org.palladiosimulator.envdyn.api.entity.bn.ConditionalInputValueUtil;
import org.palladiosimulator.envdyn.api.entity.bn.DynamicBayesianNetwork;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundRandomVariable;
import org.palladiosimulator.simexp.core.state.ArchitecturalConfiguration;
import org.palladiosimulator.simexp.distribution.function.ProbabilityMassFunction;
import org.palladiosimulator.simexp.environmentaldynamics.entity.DerivableEnvironmentalDynamic;
import org.palladiosimulator.simexp.environmentaldynamics.entity.EnvironmentalState;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivableEnvironmentalState;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivedInputValues;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivedValue;
import org.palladiosimulator.simexp.environmentaldynamics.process.EnvironmentProcess;
import org.palladiosimulator.simexp.environmentaldynamics.process.ObservableEnvironmentProcess;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.markovian.sampling.SampleDumper;
import org.palladiosimulator.simexp.markovian.statespace.StateSpaceNavigator;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.DeltaIoTSampleLogger;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.DeltaIoTModelAccess;
import org.palladiosimulator.simexp.pcm.state.PcmArchitecturalConfiguration;
import org.palladiosimulator.simexp.pcm.state.PcmSelfAdaptiveSystemState;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import org.palladiosimulator.solver.core.models.PCMInstance;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.random.ISeedProvider;

public abstract class DeltaIoTBaseEnvironemtalDynamics<R> {
    private static final Logger LOGGER = Logger.getLogger((String)DeltaIoTBaseEnvironemtalDynamics.class.getName());
    private static final String SNR_TEMPLATE = "SignalToNoiseRatio";
    private static final String MA_TEMPLATE = "MoteActivation";
    protected final EnvironmentProcess<QVTOReconfigurator, R, List<InputValue<CategoricalValue>>> envProcess;
    protected final DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess;
    private final ConditionalInputValueUtil<CategoricalValue> conditionalInputValueUtil = new ConditionalInputValueUtil();

    public DeltaIoTBaseEnvironemtalDynamics(DynamicBayesianNetwork<CategoricalValue> dbn, DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess, Optional<ISeedProvider> seedProvider) {
        this.envProcess = this.createEnvironmentalProcess(dbn, seedProvider);
        this.modelAccess = modelAccess;
    }

    private EnvironmentProcess<QVTOReconfigurator, R, List<InputValue<CategoricalValue>>> createEnvironmentalProcess(DynamicBayesianNetwork<CategoricalValue> dbn, Optional<ISeedProvider> seedProvider) {
        DeltaIoTSampleLogger deltaIoTSampleLogger = new DeltaIoTSampleLogger(this.modelAccess);
        ProbabilityMassFunction<State> initialDist = this.createInitialDist(dbn);
        initialDist.init(seedProvider);
        return new ObservableEnvironmentProcess(this.createDerivableProcess(dbn), (SampleDumper)deltaIoTSampleLogger, initialDist);
    }

    private DerivableEnvironmentalDynamic<QVTOReconfigurator> createDerivableProcess(final DynamicBayesianNetwork<CategoricalValue> dbn) {
        return new DerivableEnvironmentalDynamic<QVTOReconfigurator>(){
            private boolean explorationMode = false;

            public void pursueExplorationStrategy() {
                this.explorationMode = true;
            }

            public void pursueExploitationStrategy() {
                this.explorationMode = false;
            }

            public EnvironmentalState<List<InputValue<CategoricalValue>>> navigate(StateSpaceNavigator.NavigationContext<QVTOReconfigurator> context) {
                EnvironmentalState envState = (EnvironmentalState)EnvironmentalState.class.cast(context.getSource());
                List<InputValue<CategoricalValue>> inputs = DeltaIoTBaseEnvironemtalDynamics.toInputs(envState.getValue().getValue());
                if (this.explorationMode) {
                    return this.sampleRandomly(DeltaIoTBaseEnvironemtalDynamics.this.conditionalInputValueUtil.toConditionalInputs(inputs));
                }
                return this.sample(DeltaIoTBaseEnvironemtalDynamics.this.conditionalInputValueUtil.toConditionalInputs(inputs));
            }

            private EnvironmentalState<List<InputValue<CategoricalValue>>> sample(List<DynamicBayesianNetwork.ConditionalInputValue<CategoricalValue>> conditionalInputs) {
                DynamicBayesianNetwork.Trajectory traj = dbn.given(DeltaIoTBaseEnvironemtalDynamics.this.conditionalInputValueUtil.asConditionals(conditionalInputs)).sample();
                PerceivedValue<List<InputValue<CategoricalValue>>> value = DeltaIoTBaseEnvironemtalDynamics.this.toPerceivedValue(traj.valueAtTime(0));
                EnvironmentalState.EnvironmentalStateBuilder builder = EnvironmentalState.newBuilder();
                return builder.withValue(value).build();
            }

            private EnvironmentalState<List<InputValue<CategoricalValue>>> sampleRandomly(List<DynamicBayesianNetwork.ConditionalInputValue<CategoricalValue>> conditionalInputs) {
                throw new RuntimeException(new OperationNotSupportedException("The method is not implemented yet."));
            }
        };
    }

    private ProbabilityMassFunction<State> createInitialDist(DynamicBayesianNetwork<CategoricalValue> dbn) {
        return new ProbabilityMassFunction<State>(dbn){
            private final BayesianNetwork<CategoricalValue> bn;
            private boolean initialized;
            {
                this.bn = dynamicBayesianNetwork.getBayesianNetwork();
                this.initialized = false;
            }

            public void init(Optional<ISeedProvider> seedProvider) {
                this.initialized = true;
                this.bn.init(seedProvider);
            }

            public ProbabilityMassFunction.Sample<State> drawSample() {
                if (!this.initialized) {
                    throw new RuntimeException("not initialized");
                }
                List sample = this.bn.sample();
                EnvironmentalState.EnvironmentalStateBuilder builder = EnvironmentalState.newBuilder();
                EnvironmentalState newState = builder.withValue(DeltaIoTBaseEnvironemtalDynamics.this.toPerceivedValue(sample)).isInital().build();
                return ProbabilityMassFunction.Sample.of((Object)newState, (double)this.bn.probability(sample));
            }

            public double probability(ProbabilityMassFunction.Sample<State> sample) {
                List<InputValue<CategoricalValue>> inputs = DeltaIoTBaseEnvironemtalDynamics.toInputs(sample);
                if (inputs.isEmpty()) {
                    return 0.0;
                }
                return this.bn.probability(inputs);
            }
        };
    }

    protected PerceivedValue<List<InputValue<CategoricalValue>>> toPerceivedValue(List<InputValue<CategoricalValue>> sample) {
        PerceivedInputValues perceivedValue = new PerceivedInputValues(sample);
        return perceivedValue;
    }

    public static <A> PcmSelfAdaptiveSystemState<A, List<InputValue<CategoricalValue>>> asPcmState(State state) {
        return (PcmSelfAdaptiveSystemState)PcmSelfAdaptiveSystemState.class.cast(state);
    }

    public static <A> PerceivableEnvironmentalState<List<InputValue<CategoricalValue>>> getCurrentEnvironment(StateSpaceNavigator.NavigationContext<A> context) {
        return DeltaIoTBaseEnvironemtalDynamics.asPcmState(context.getSource()).getPerceivedEnvironmentalState();
    }

    public static <A> PcmArchitecturalConfiguration<A> getCurrentArchitecture(StateSpaceNavigator.NavigationContext<A> context) {
        PcmSelfAdaptiveSystemState<A, List<InputValue<CategoricalValue>>> pcmState = DeltaIoTBaseEnvironemtalDynamics.asPcmState(context.getSource());
        ArchitecturalConfiguration pcmConfig = pcmState.getArchitecturalConfiguration();
        return (PcmArchitecturalConfiguration)PcmArchitecturalConfiguration.class.cast(pcmConfig);
    }

    public static List<InputValue<CategoricalValue>> toInputs(Object sample) {
        List inputs;
        if (List.class.isInstance(sample) && !(inputs = (List)List.class.cast(sample)).isEmpty() && InputValue.class.isInstance(inputs.get(0))) {
            return inputs.stream().map(InputValue.class::cast).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    protected static Predicate<GroundRandomVariable> isWITemplate() {
        return DeltaIoTBaseEnvironemtalDynamics.isMATemplate().or(v -> DeltaIoTBaseEnvironemtalDynamics.isSNRTemplate(v)).negate();
    }

    protected static Predicate<GroundRandomVariable> isMATemplate() {
        return v -> v.getInstantiatedTemplate().getEntityName().equals(MA_TEMPLATE);
    }

    public static boolean isSNRTemplate(GroundRandomVariable variable) {
        return variable.getInstantiatedTemplate().getEntityName().equals(SNR_TEMPLATE);
    }
}

