/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.palladiosimulator.envdyn.api.entity.bn.DynamicBayesianNetwork;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.experimentautomation.experiments.Experiment;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurementSpecification;
import org.palladiosimulator.simexp.core.evaluation.ExpectedRewardEvaluator;
import org.palladiosimulator.simexp.core.evaluation.TotalRewardCalculation;
import org.palladiosimulator.simexp.core.process.ExperienceSimulator;
import org.palladiosimulator.simexp.core.state.SimulationRunnerHolder;
import org.palladiosimulator.simexp.core.statespace.SelfAdaptiveSystemStateSpaceNavigator;
import org.palladiosimulator.simexp.core.store.SimulatedExperienceStore;
import org.palladiosimulator.simexp.core.util.SimulatedExperienceConstants;
import org.palladiosimulator.simexp.markovian.activity.Policy;
import org.palladiosimulator.simexp.pcm.action.IQVToReconfigurationManager;
import org.palladiosimulator.simexp.pcm.action.IQVToReconfigurationProvider;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.config.IPrismConfiguration;
import org.palladiosimulator.simexp.pcm.config.IPrismWorkflowConfiguration;
import org.palladiosimulator.simexp.pcm.config.ITransformationConfiguration;
import org.palladiosimulator.simexp.pcm.config.IWorkflowConfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.DeltaIoTPartiallyEnvDynamics;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.DeltaIoTQVToReconfigurationProvider;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.DeltaIoTSampleLogger;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.DeltaIoToReconfCustomizerResolver;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.param.reconfigurationparams.DeltaIoTReconfigurationParamRepository;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.process.DeltaIoTPcmBasedPrismExperienceSimulationRunner;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.process.DeltaIoTPrismFileUpdater;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.process.EnergyConsumptionPrismFileUpdater;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.process.PacketLossPrismFileUpdater;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.provider.PrismMeasurementSpecificationProvider;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration.DeltaIoToReconfCustomizerFactory;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.reward.QualityBasedRewardEvaluator;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.strategy.DeltaIoTDefaultReconfigurationStrategy;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.DeltaIoTModelAccess;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.DeltaIoTReconfigurationParamsLoader;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.DeltaIotCSVSystemConfigurationStatisticSink;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.SystemConfigurationTracker;
import org.palladiosimulator.simexp.pcm.examples.executor.ModelLoader;
import org.palladiosimulator.simexp.pcm.examples.executor.PcmExperienceSimulationExecutor;
import org.palladiosimulator.simexp.pcm.examples.executor.PcmExperienceSimulationExecutorFactory;
import org.palladiosimulator.simexp.pcm.init.GlobalPcmBeforeExecutionInitialization;
import org.palladiosimulator.simexp.pcm.prism.entity.PrismSimulatedMeasurementSpec;
import org.palladiosimulator.simexp.pcm.prism.generator.PrismFileUpdateGenerator;
import org.palladiosimulator.simexp.pcm.util.IExperimentProvider;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import org.palladiosimulator.solver.core.models.PCMInstance;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.random.ISeedProvider;

public class DeltaIoTSimulationExecutorFactory
extends PcmExperienceSimulationExecutorFactory<Double, List<InputValue<CategoricalValue>>, PrismSimulatedMeasurementSpec> {
    private static final Logger LOGGER = Logger.getLogger(DeltaIoTSimulationExecutorFactory.class);
    public static final String DELTAIOT_PATH = "/org.palladiosimulator.envdyn.examples.deltaiot";
    public static final String DISTRIBUTION_FACTORS = "/org.palladiosimulator.envdyn.examples.deltaiot/model/DeltaIoTReconfigurationParams.reconfigurationparams";

    public DeltaIoTSimulationExecutorFactory(IPrismWorkflowConfiguration workflowConfiguration, ModelLoader.Factory modelLoaderFactory, SimulatedExperienceStore<QVTOReconfigurator, Double> simulatedExperienceStore, Optional<ISeedProvider> seedProvider) {
        super((IWorkflowConfiguration)workflowConfiguration, modelLoaderFactory, simulatedExperienceStore, seedProvider);
    }

    protected IPrismWorkflowConfiguration getWorkflowConfiguration() {
        return (IPrismWorkflowConfiguration)super.getWorkflowConfiguration();
    }

    protected List<PrismSimulatedMeasurementSpec> createSpecs(Experiment experiment) {
        PrismMeasurementSpecificationProvider provider = new PrismMeasurementSpecificationProvider((IPrismConfiguration)this.getWorkflowConfiguration());
        List<PrismSimulatedMeasurementSpec> prismSpecs = provider.getSpecifications();
        return prismSpecs;
    }

    protected PcmExperienceSimulationExecutor<PCMInstance, QVTOReconfigurator, QVToReconfiguration, Double> doCreate(Experiment experiment, DynamicBayesianNetwork<CategoricalValue> dbn) {
        DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess = new DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator>();
        SimulationRunnerHolder simulationRunnerHolder = this.createSimulationRunnerHolder();
        DeltaIoTPartiallyEnvDynamics p = new DeltaIoTPartiallyEnvDynamics(dbn, this.getSimulatedExperienceStore(), modelAccess, this.getSeedProvider(), simulationRunnerHolder);
        SelfAdaptiveSystemStateSpaceNavigator envProcess = p.getEnvironmentProcess();
        String strategyId = this.getWorkflowConfiguration().getSimulationParameters().getSimulationID();
        Path prismFolder = this.getPrismFolder(strategyId);
        try {
            Files.createDirectories(prismFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        LinkedHashSet<DeltaIoTPrismFileUpdater> prismFileUpdaters = new LinkedHashSet<DeltaIoTPrismFileUpdater>();
        List<PrismSimulatedMeasurementSpec> prismSimulatedMeasurementSpec = this.createSpecs(experiment);
        SimulatedMeasurementSpecification packetLossSpec = this.findPrismMeasurementSpec(prismSimulatedMeasurementSpec, "PacketLoss.prism");
        PacketLossPrismFileUpdater packetLossUpdater = new PacketLossPrismFileUpdater((PrismSimulatedMeasurementSpec)packetLossSpec, modelAccess);
        prismFileUpdaters.add(packetLossUpdater);
        SimulatedMeasurementSpecification energyConsumptionSpec = this.findPrismMeasurementSpec(prismSimulatedMeasurementSpec, "EnergyConsumption.prism");
        EnergyConsumptionPrismFileUpdater engergyConsumptionUpdater = new EnergyConsumptionPrismFileUpdater((PrismSimulatedMeasurementSpec)energyConsumptionSpec);
        prismFileUpdaters.add(engergyConsumptionUpdater);
        PrismFileUpdateGenerator prismGenerator = new PrismFileUpdateGenerator(prismFileUpdaters);
        DeltaIoTReconfigurationParamRepository reconfParamsRepo = new DeltaIoTReconfigurationParamsLoader().load(DISTRIBUTION_FACTORS);
        IQVToReconfigurationManager qvtoReconfigurationManager = this.createQvtoReconfigurationManager(experiment, (ITransformationConfiguration)this.getWorkflowConfiguration());
        qvtoReconfigurationManager.addModelsToTransform(reconfParamsRepo.eResource());
        IExperimentProvider experimentProvider = this.createExperimentProvider(experiment);
        DeltaIoTPcmBasedPrismExperienceSimulationRunner runner = new DeltaIoTPcmBasedPrismExperienceSimulationRunner(prismGenerator, prismFolder, strategyId, reconfParamsRepo, experimentProvider);
        ArrayList<GlobalPcmBeforeExecutionInitialization> beforeExecutionInitializables = new ArrayList<GlobalPcmBeforeExecutionInitialization>();
        GlobalPcmBeforeExecutionInitialization beforeExecutionInitializable = new GlobalPcmBeforeExecutionInitialization(experimentProvider, qvtoReconfigurationManager);
        beforeExecutionInitializables.add(beforeExecutionInitializable);
        SystemConfigurationTracker systemConfigTracker = new SystemConfigurationTracker(this.getSimulationParameters());
        Path csvPath = this.getCSVPath(strategyId);
        try {
            Files.createDirectories(csvPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        DeltaIotCSVSystemConfigurationStatisticSink csvSink = new DeltaIotCSVSystemConfigurationStatisticSink(csvPath);
        systemConfigTracker.addStatisticSink(csvSink);
        DeltaIoToReconfCustomizerFactory reconfCustomizerFactory = new DeltaIoToReconfCustomizerFactory(reconfParamsRepo);
        DeltaIoToReconfCustomizerResolver reconfCustomizerResolver = new DeltaIoToReconfCustomizerResolver();
        DeltaIoTDefaultReconfigurationStrategy reconfSelectionPolicy = new DeltaIoTDefaultReconfigurationStrategy(reconfParamsRepo, modelAccess, this.getSimulationParameters(), systemConfigTracker, reconfCustomizerResolver);
        QualityBasedRewardEvaluator evaluator = new QualityBasedRewardEvaluator(packetLossSpec, energyConsumptionSpec);
        IQVToReconfigurationProvider qvToReconfigurationProvider = qvtoReconfigurationManager.getQVToReconfigurationProvider();
        DeltaIoTQVToReconfigurationProvider deltaIoTQVTOReconfigurationProvider = new DeltaIoTQVToReconfigurationProvider(qvToReconfigurationProvider, reconfCustomizerFactory);
        Set<QVToReconfiguration> reconfigurations = deltaIoTQVTOReconfigurationProvider.getReconfigurations();
        DeltaIoTSampleLogger deltaIoTSampleLogger = new DeltaIoTSampleLogger(modelAccess);
        ExperienceSimulator simulator = this.createExperienceSimulator(experiment, prismSimulatedMeasurementSpec, List.of(runner), this.getSimulationParameters(), beforeExecutionInitializables, null, this.getSimulatedExperienceStore(), envProcess, (Policy)reconfSelectionPolicy, reconfigurations, evaluator, false, experimentProvider, simulationRunnerHolder, deltaIoTSampleLogger, this.getSeedProvider());
        String sampleSpaceId = SimulatedExperienceConstants.constructSampleSpaceId((String)this.getSimulationParameters().getSimulationID(), (String)reconfSelectionPolicy.getId());
        ExpectedRewardEvaluator rewardCalculation = new ExpectedRewardEvaluator(this.getSimulationParameters().getSimulationID(), sampleSpaceId);
        return new PcmExperienceSimulationExecutor(simulator, experiment, this.getSimulationParameters(), (Policy)reconfSelectionPolicy, (TotalRewardCalculation)rewardCalculation, experimentProvider);
    }

    private Path getPrismFolder(String strategyId) {
        IPath workspaceBasePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        Path outputBasePath = Paths.get(workspaceBasePath.toString(), new String[0]);
        Path resourcePath = outputBasePath.resolve("resource");
        Path prismStrategyPath = resourcePath.resolve(strategyId);
        Path prismPath = prismStrategyPath.resolve("prism");
        return prismPath;
    }

    private Path getCSVPath(String strategyId) {
        IPath workspaceBasePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        Path outputBasePath = Paths.get(workspaceBasePath.toString(), "resource", strategyId);
        String csvFileName = String.valueOf(strategyId) + "Configurations.csv";
        Path csvFilePath = Paths.get(outputBasePath.toString(), csvFileName);
        return csvFilePath;
    }

    private SimulatedMeasurementSpecification findPrismMeasurementSpec(List<PrismSimulatedMeasurementSpec> specs, String id) {
        for (SimulatedMeasurementSpecification simulatedMeasurementSpecification : specs) {
            if (simulatedMeasurementSpecification.getId().compareTo(id) != 0) continue;
            return simulatedMeasurementSpecification;
        }
        return null;
    }
}

