/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot.provider;

import java.io.File;
import java.util.List;
import java.util.stream.IntStream;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.simexp.pcm.config.IPrismConfiguration;
import org.palladiosimulator.simexp.pcm.prism.entity.PrismSimulatedMeasurementSpec;

public class PrismMeasurementSpecificationProvider {
    private final IPrismConfiguration workflowConfiguration;

    public PrismMeasurementSpecificationProvider(IPrismConfiguration workflowConfiguration) {
        this.workflowConfiguration = workflowConfiguration;
    }

    public List<PrismSimulatedMeasurementSpec> getSpecifications() {
        List propertyFiles = this.workflowConfiguration.getPropertyFiles();
        List moduleFiles = this.workflowConfiguration.getModuleFiles();
        List<PrismSimulatedMeasurementSpec> prismSpecs = IntStream.range(0, Math.min(propertyFiles.size(), moduleFiles.size())).mapToObj(i -> this.getSpecification((URI)moduleFiles.get(i), (URI)propertyFiles.get(i))).toList();
        return prismSpecs;
    }

    private PrismSimulatedMeasurementSpec getSpecification(URI moduleUri, URI propertyUri) {
        String propertyFileAsString = CommonPlugin.resolve((URI)propertyUri).toFileString();
        File propertyFile = new File(propertyFileAsString);
        String moduleFileAsString = CommonPlugin.resolve((URI)moduleUri).toFileString();
        File moduleFile = new File(moduleFileAsString);
        return new PrismSimulatedMeasurementSpec(moduleFile, propertyFile);
    }
}

