/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration;

import com.google.common.collect.Lists;
import com.google.common.math.DoubleMath;
import java.util.ArrayList;
import java.util.Map;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.simexp.pcm.action.SingleQVToReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration.IDeltaIoToReconfiguration;

public abstract class DeltaIoTBaseReconfiguration
extends SingleQVToReconfiguration
implements IDeltaIoToReconfiguration {
    private static final double TOLERANCE = 0.001;

    public DeltaIoTBaseReconfiguration(SingleQVToReconfiguration reconfiguration) {
        super(reconfiguration);
    }

    public boolean isValid(Map<ProbabilisticBranchTransition, Double> factors) {
        if (factors.size() != 2) {
            return false;
        }
        ArrayList transitions = Lists.newArrayList(factors.keySet());
        double branchProb1 = ((ProbabilisticBranchTransition)transitions.get(0)).getBranchProbability() + factors.get(transitions.get(0));
        double branchProb2 = ((ProbabilisticBranchTransition)transitions.get(1)).getBranchProbability() + factors.get(transitions.get(1));
        boolean sumsUpToOne = DoubleMath.fuzzyEquals((double)(branchProb1 + branchProb2), (double)1.0, (double)0.001);
        boolean areInRange = Boolean.logicalAnd(Boolean.logicalAnd(branchProb1 >= 0.0, branchProb1 <= 1.0), Boolean.logicalAnd(branchProb2 >= 0.0, branchProb2 <= 1.0));
        return Boolean.logicalAnd(sumsUpToOne, areInRange);
    }

    public boolean isNotValid(Map<ProbabilisticBranchTransition, Double> factors) {
        return !this.isValid(factors);
    }
}

