/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.strategy.MoteContext;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.IConfigurationStatisticSink;

public class DeltaIotCSVSystemConfigurationStatisticSink
implements IConfigurationStatisticSink {
    private final Path outputPath;
    private CSVPrinter printer;

    public DeltaIotCSVSystemConfigurationStatisticSink(Path outputPath) {
        this.outputPath = outputPath;
    }

    @Override
    public void initialize() throws IOException {
        String[] HEADERS = new String[]{"Run", "Link", "Power", "Distribution"};
        CSVFormat csvFormat = CSVFormat.newFormat((char)';').withHeader(HEADERS).withRecordSeparator("\r\n");
        BufferedWriter writer = Files.newBufferedWriter(this.outputPath, new OpenOption[0]);
        this.printer = new CSVPrinter((Appendable)writer, csvFormat);
    }

    @Override
    public void onEntry(int run, MoteContext.WirelessLink link) throws IOException {
        this.printer.printRecord(new Object[]{run, link.pcmLink.getEntityName(), link.transmissionPower, link.distributionFactor});
    }

    @Override
    public void finalize() throws IOException {
        try {
            this.printer.close();
        }
        finally {
            this.printer = null;
        }
    }

    @Override
    public void onRunStart(int run) {
    }

    @Override
    public void onRunFinish(int run) {
    }
}

