/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot.process;

import java.util.List;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.parameter.VariableCharacterisation;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.simexp.environmentaldynamics.entity.PerceivableEnvironmentalState;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.process.DeltaIoTPrismFileUpdater;
import org.palladiosimulator.simexp.pcm.prism.entity.PrismContext;
import org.palladiosimulator.simexp.pcm.prism.entity.PrismSimulatedMeasurementSpec;
import org.palladiosimulator.simexp.pcm.state.PcmSelfAdaptiveSystemState;
import org.palladiosimulator.solver.core.models.PCMInstance;
import tools.mdsd.probdist.api.entity.CategoricalValue;

public class EnergyConsumptionPrismFileUpdater<A>
extends DeltaIoTPrismFileUpdater<A> {
    public EnergyConsumptionPrismFileUpdater(PrismSimulatedMeasurementSpec prismSpec) {
        super(prismSpec);
    }

    public PrismContext apply(PcmSelfAdaptiveSystemState<A, List<InputValue<CategoricalValue>>> sasState) {
        PrismContext prismContext = new PrismContext("EnergyConsumption", this.stringify(this.prismSpec.getModuleFile()), this.stringify(this.prismSpec.getPropertyFile()));
        this.substituteMoteActivations(prismContext, sasState);
        this.substituteTransmissionPower(prismContext, sasState);
        this.substituteDistributionFactor(prismContext, sasState, f -> Double.valueOf(f * 100.0).intValue());
        return prismContext;
    }

    private void substituteTransmissionPower(PrismContext prismContext, PcmSelfAdaptiveSystemState<A, List<InputValue<CategoricalValue>>> sasState) {
        System system = ((PCMInstance)sasState.getArchitecturalConfiguration().getConfiguration()).getSystem();
        for (AssemblyContext each : system.getAssemblyContexts__ComposedStructure()) {
            if (!this.isInstantiatedSensorMote(each, sasState)) continue;
            this.substituteTransmissionPower(prismContext, (List<VariableUsage>)each.getConfigParameterUsages__AssemblyContext());
        }
    }

    private void substituteTransmissionPower(PrismContext prismContext, List<VariableUsage> configParameter) {
        configParameter.forEach(param -> this.substituteTransmissionPower(prismContext, (VariableUsage)param));
    }

    private void substituteTransmissionPower(PrismContext prismContext, VariableUsage configParameter) {
        String unresolvedSymbol = configParameter.getNamedReference__VariableUsage().getReferenceName();
        String value = ((VariableCharacterisation)configParameter.getVariableCharacterisation_VariableUsage().get(0)).getSpecification_VariableCharacterisation().getSpecification();
        this.resolveAndSubstitute(prismContext, unresolvedSymbol, value);
    }

    private boolean isInstantiatedSensorMote(AssemblyContext each, PcmSelfAdaptiveSystemState<A, List<InputValue<CategoricalValue>>> sasState) {
        return !this.resolveInputValue(each, (PerceivableEnvironmentalState<List<InputValue<CategoricalValue>>>)sasState.getPerceivedEnvironmentalState()).isEmpty();
    }
}

