/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot.strategy;

import com.google.common.math.DoubleMath;
import de.uka.ipd.sdq.stoex.VariableReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.simexp.core.strategy.ReconfigurationStrategy;
import org.palladiosimulator.simexp.core.strategy.SharedKnowledge;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.markovian.sampling.SampleDumper;
import org.palladiosimulator.simexp.pcm.action.EmptyQVToReconfiguration;
import org.palladiosimulator.simexp.pcm.action.MultiQVToReconfiguration;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.action.SingleQVToReconfiguration;
import org.palladiosimulator.simexp.pcm.config.SimulationParameters;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.DeltaIoTSampleLogger;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.param.reconfigurationparams.DeltaIoTReconfigurationParamRepository;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration.IDeltaIoToReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration.IDistributionFactorReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration.ITransmissionPowerReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.strategy.IDeltaIoToReconfCustomizerResolver;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.strategy.MoteContext;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.DeltaIoTCommons;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.DeltaIoTModelAccess;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.ReconfigurationParameterCalculator;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.SystemConfigurationTracker;
import org.palladiosimulator.simexp.pcm.state.PcmSelfAdaptiveSystemState;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class DeltaIoTDefaultReconfigurationStrategy
extends ReconfigurationStrategy<QVTOReconfigurator, QVToReconfiguration> {
    private static final double UNIFORM_DIST_VALUE = 0.5;
    private final ReconfigurationParameterCalculator paramCalculator;
    private final DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess;
    private final SimulationParameters simulationParameters;
    private final SystemConfigurationTracker systemConfigurationTracker;
    private final IDeltaIoToReconfCustomizerResolver reconfCustomizerResolver;

    public DeltaIoTDefaultReconfigurationStrategy(DeltaIoTReconfigurationParamRepository reconfParamsRepo, DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess, SimulationParameters simulationParameters, SystemConfigurationTracker systemConfigurationTracker, IDeltaIoToReconfCustomizerResolver reconfCustomizerResolver) {
        super((SampleDumper)new DeltaIoTSampleLogger(modelAccess));
        this.paramCalculator = new ReconfigurationParameterCalculator(reconfParamsRepo, modelAccess);
        this.modelAccess = modelAccess;
        this.simulationParameters = simulationParameters;
        this.systemConfigurationTracker = systemConfigurationTracker;
        this.reconfCustomizerResolver = reconfCustomizerResolver;
    }

    public String getId() {
        return "DefaultDeltaIoTStrategy";
    }

    protected void monitor(State source, SharedKnowledge knowledge) {
        this.systemConfigurationTracker.prepareNetworkConfig();
        DeltaIoTCommons.requirePcmSelfAdaptiveSystemState(source);
        PcmSelfAdaptiveSystemState state = (PcmSelfAdaptiveSystemState)PcmSelfAdaptiveSystemState.class.cast(source);
        knowledge.store("PCM_STATE", (Object)state);
        this.addMonitoredEnvironmentValues(state, knowledge);
        this.systemConfigurationTracker.processNetworkConfig(knowledge);
    }

    protected boolean analyse(State source, SharedKnowledge knowledge) {
        MoteContext.MoteContextFilter moteFiler = new MoteContext.MoteContextFilter(knowledge);
        for (MoteContext eachMote : moteFiler.getAllMoteContexts()) {
            for (MoteContext.WirelessLink eachLink : eachMote.links) {
                if (this.isPowerOptimal(eachLink)) continue;
                return true;
            }
            if (!eachMote.hasTwoLinks() || !eachMote.hasUnequalTransmissionPower()) continue;
            return true;
        }
        return false;
    }

    protected QVToReconfiguration plan(State source, Set<QVToReconfiguration> options, SharedKnowledge knowledge) {
        IDeltaIoToReconfiguration customizer = this.reconfCustomizerResolver.resolveDeltaIoTReconfCustomizer(options);
        if (customizer instanceof IDistributionFactorReconfiguration) {
            IDistributionFactorReconfiguration distributionFactorReconfiguration = (IDistributionFactorReconfiguration)customizer;
            distributionFactorReconfiguration.setDistributionFactorValuesToDefaults();
        }
        MoteContext.MoteContextFilter moteFiler = new MoteContext.MoteContextFilter(knowledge);
        for (MoteContext eachMote : moteFiler.getAllMoteContexts()) {
            for (MoteContext.WirelessLink eachLink : eachMote.links) {
                if (!(customizer instanceof ITransmissionPowerReconfiguration)) continue;
                ITransmissionPowerReconfiguration transmissionPowerReconfiguration = (ITransmissionPowerReconfiguration)customizer;
                if (eachLink.SNR > 0.0 && eachLink.transmissionPower > 0) {
                    this.decreaseTransmissionPower(eachMote.mote, eachLink, transmissionPowerReconfiguration);
                    continue;
                }
                if (!(eachLink.SNR < 0.0) || eachLink.transmissionPower >= 15) continue;
                this.increaseTransmissionPower(eachMote.mote, eachLink, transmissionPowerReconfiguration);
            }
            if (!eachMote.hasTwoLinks() || !(customizer instanceof IDistributionFactorReconfiguration)) continue;
            IDistributionFactorReconfiguration distributionFactorReconfiguration = (IDistributionFactorReconfiguration)customizer;
            if (!eachMote.hasUnequalTransmissionPower()) continue;
            Iterator<MoteContext.WirelessLink> iterator = eachMote.links.iterator();
            MoteContext.WirelessLink left = iterator.next();
            double leftTransmissionPower = left.transmissionPower;
            double leftDistributionFactor = left.distributionFactor;
            MoteContext.WirelessLink right = iterator.next();
            double rightTransmissionPower = right.transmissionPower;
            double rightDistributionFactor = right.distributionFactor;
            if (this.isEqualToOne(leftDistributionFactor) && this.isEqualToOne(rightDistributionFactor)) {
                this.setDistributionFactorsUniformally(distributionFactorReconfiguration, eachMote.mote);
            }
            if (leftTransmissionPower > rightTransmissionPower && this.isSmallerThanOne(leftDistributionFactor)) {
                this.adjustDistributionFactor(right, eachMote, distributionFactorReconfiguration);
                continue;
            }
            if (!this.isSmallerThanOne(rightDistributionFactor)) continue;
            this.adjustDistributionFactor(left, eachMote, distributionFactorReconfiguration);
        }
        ArrayList<SingleQVToReconfiguration> singleReconfigurations = new ArrayList<SingleQVToReconfiguration>();
        for (QVToReconfiguration qvto : options) {
            singleReconfigurations.add((SingleQVToReconfiguration)qvto);
        }
        MultiQVToReconfiguration reconfiguration = MultiQVToReconfiguration.of(singleReconfigurations);
        return reconfiguration;
    }

    private void setDistributionFactorsUniformally(IDistributionFactorReconfiguration reconfiguration, AssemblyContext mote) {
        List<ProbabilisticBranchTransition> communicatingBranches = this.modelAccess.retrieveCommunicatingBranches(mote);
        for (ProbabilisticBranchTransition branch : communicatingBranches) {
            Map<ProbabilisticBranchTransition, Double> factors = Collections.singletonMap(branch, 0.5);
            reconfiguration.adjustDistributionFactor(factors);
        }
    }

    protected QVToReconfiguration emptyReconfiguration() {
        return EmptyQVToReconfiguration.empty();
    }

    private void addMonitoredEnvironmentValues(PcmSelfAdaptiveSystemState state, SharedKnowledge knowledge) {
        Map<AssemblyContext, Map<LinkingResource, Double>> motesToLinks = DeltaIoTCommons.filterMotesWithWirelessLinks(this.modelAccess, state);
        for (AssemblyContext each : motesToLinks.keySet()) {
            MoteContext moteContext = new MoteContext(this.modelAccess, each, motesToLinks.get(each));
            knowledge.store(moteContext.getId(), (Object)moteContext);
        }
    }

    private boolean isPowerOptimal(MoteContext.WirelessLink link) {
        return link.SNR > 0.0 && link.transmissionPower > 0 || link.SNR < 0.0 && link.transmissionPower < 15;
    }

    private void decreaseTransmissionPower(AssemblyContext mote, MoteContext.WirelessLink link, ITransmissionPowerReconfiguration reconfiguration) {
        Map<VariableReference, Integer> adjustedParams = this.paramCalculator.computeDecreasedTransmissionPower(mote, link);
        reconfiguration.adjustTransmissionPower(adjustedParams);
    }

    private void increaseTransmissionPower(AssemblyContext mote, MoteContext.WirelessLink link, ITransmissionPowerReconfiguration reconfiguration) {
        Map<VariableReference, Integer> adjustedParams = this.paramCalculator.computeIncreasedTransmissionPower(mote, link);
        reconfiguration.adjustTransmissionPower(adjustedParams);
    }

    private void adjustDistributionFactor(MoteContext.WirelessLink linkToDecrease, MoteContext mote, IDistributionFactorReconfiguration reconfiguration) {
        Map<ProbabilisticBranchTransition, Double> adjustedParams = this.paramCalculator.computeAdjustedDistributionFactors(linkToDecrease, mote);
        reconfiguration.adjustDistributionFactor(adjustedParams);
    }

    private boolean isSmallerThanOne(double distributionFactor) {
        return distributionFactor < 1.0 && !this.isEqualToOne(distributionFactor);
    }

    private boolean isEqualToOne(double distributionFactor) {
        double TOLERANCE = 1.0E-4;
        return DoubleMath.fuzzyEquals((double)distributionFactor, (double)1.0, (double)TOLERANCE);
    }
}

