/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot.strategy;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurement;
import org.palladiosimulator.simexp.core.entity.SimulatedMeasurementSpecification;
import org.palladiosimulator.simexp.core.strategy.ReconfigurationStrategy;
import org.palladiosimulator.simexp.core.strategy.SharedKnowledge;
import org.palladiosimulator.simexp.markovian.model.markovmodel.markoventity.State;
import org.palladiosimulator.simexp.markovian.sampling.SampleDumper;
import org.palladiosimulator.simexp.pcm.action.EmptyQVToReconfiguration;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.config.SimulationParameters;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.DeltaIoTSampleLogger;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration.IDeltaIoToReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration.IDistributionFactorReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.strategy.IDeltaIoToReconfCustomizerResolver;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.strategy.MoteContext;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.strategy.QualityBasedReconfigurationPlanner;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.DeltaIoTCommons;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.DeltaIoTModelAccess;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.SystemConfigurationTracker;
import org.palladiosimulator.simexp.pcm.prism.entity.PrismSimulatedMeasurementSpec;
import org.palladiosimulator.simexp.pcm.state.PcmSelfAdaptiveSystemState;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class DeltaIoTReconfigurationStrategy2
extends ReconfigurationStrategy<QVTOReconfigurator, QVToReconfiguration> {
    private final String id;
    private final QualityBasedReconfigurationPlanner planner;
    private final PrismSimulatedMeasurementSpec packetLossSpec;
    private final PrismSimulatedMeasurementSpec energyConsumptionSpec;
    private final DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess;
    private final SimulationParameters simulationParameters;
    private final SystemConfigurationTracker systemConfigurationTracker;
    private final IDeltaIoToReconfCustomizerResolver reconfCustomizerResolver;

    private DeltaIoTReconfigurationStrategy2(String id, QualityBasedReconfigurationPlanner planner, PrismSimulatedMeasurementSpec packetLossSpec, PrismSimulatedMeasurementSpec energyConsumptionSpec, DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess, SimulationParameters simulationParameters, SystemConfigurationTracker systemConfigurationTracker, IDeltaIoToReconfCustomizerResolver reconfCustomizerResolver) {
        super((SampleDumper)new DeltaIoTSampleLogger(modelAccess));
        this.id = id;
        this.planner = planner;
        this.packetLossSpec = packetLossSpec;
        this.energyConsumptionSpec = energyConsumptionSpec;
        this.modelAccess = modelAccess;
        this.simulationParameters = simulationParameters;
        this.systemConfigurationTracker = systemConfigurationTracker;
        this.reconfCustomizerResolver = reconfCustomizerResolver;
    }

    public static DeltaIoTReconfigurationStrategy2Builder newBuilder(DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess, SimulationParameters simulationParameters, SystemConfigurationTracker systemConfigurationTracker, IDeltaIoToReconfCustomizerResolver reconfCustomizerResolver) {
        return new DeltaIoTReconfigurationStrategy2Builder(modelAccess, simulationParameters, systemConfigurationTracker, reconfCustomizerResolver);
    }

    public String getId() {
        return this.id;
    }

    protected void monitor(State source, SharedKnowledge knowledge) {
        this.systemConfigurationTracker.prepareNetworkConfig();
        DeltaIoTCommons.requirePcmSelfAdaptiveSystemState(source);
        PcmSelfAdaptiveSystemState state = (PcmSelfAdaptiveSystemState)PcmSelfAdaptiveSystemState.class.cast(source);
        knowledge.store("PCM_STATE", (Object)state);
        this.addMonitoredEnvironmentValues(state, knowledge);
        this.addMonitoredQualityValues(state, knowledge);
        this.systemConfigurationTracker.processNetworkConfig(knowledge);
    }

    protected boolean analyse(State source, SharedKnowledge knowledge) {
        double packetLoss = knowledge.getValue("PacketLoss").map(Double.class::cast).orElseThrow();
        double energyConsumption = knowledge.getValue("EnergyConsumption").map(Double.class::cast).orElseThrow();
        return this.isPacketLossViolated(packetLoss) || this.isEnergyConsumptionViolated(energyConsumption);
    }

    protected QVToReconfiguration plan(State source, Set<QVToReconfiguration> options, SharedKnowledge knowledge) {
        IDeltaIoToReconfiguration deltaIoTReconfiguration = this.reconfCustomizerResolver.resolveDeltaIoTReconfCustomizer(options);
        if (deltaIoTReconfiguration instanceof IDistributionFactorReconfiguration) {
            IDistributionFactorReconfiguration distributionFactorReconfiguration = (IDistributionFactorReconfiguration)deltaIoTReconfiguration;
            distributionFactorReconfiguration.setDistributionFactorValuesToDefaults();
        }
        knowledge.store("OPTIONS", options);
        double energyConsumption = knowledge.getValue("EnergyConsumption").map(Double.class::cast).orElseThrow();
        if (this.isEnergyConsumptionViolated(energyConsumption)) {
            return this.planner.planEnergyConsumption(knowledge);
        }
        return this.planner.planPacketLoss(knowledge);
    }

    protected QVToReconfiguration emptyReconfiguration() {
        return EmptyQVToReconfiguration.empty();
    }

    private void addMonitoredEnvironmentValues(PcmSelfAdaptiveSystemState state, SharedKnowledge knowledge) {
        Map<AssemblyContext, Map<LinkingResource, Double>> motesToLinks = DeltaIoTCommons.filterMotesWithWirelessLinks(this.modelAccess, state);
        for (AssemblyContext each : motesToLinks.keySet()) {
            MoteContext moteContext = new MoteContext(this.modelAccess, each, motesToLinks.get(each));
            knowledge.store(moteContext.getId(), (Object)moteContext);
        }
    }

    private void addMonitoredQualityValues(PcmSelfAdaptiveSystemState state, SharedKnowledge knowledge) {
        SimulatedMeasurement packetLoss = (SimulatedMeasurement)state.getQuantifiedState().findMeasurementWith((SimulatedMeasurementSpecification)this.packetLossSpec).orElseThrow(() -> new RuntimeException(String.format("There is no simulated measurement for spec %s", this.packetLossSpec.getName())));
        knowledge.store("PacketLoss", (Object)packetLoss.getValue());
        SimulatedMeasurement energyConsumtption = (SimulatedMeasurement)state.getQuantifiedState().findMeasurementWith((SimulatedMeasurementSpecification)this.energyConsumptionSpec).orElseThrow(() -> new RuntimeException(String.format("There is no simulated measurement for spec %s", this.energyConsumptionSpec.getName())));
        knowledge.store("EnergyConsumption", (Object)energyConsumtption.getValue());
    }

    private boolean isPacketLossViolated(double packetLoss) {
        return DeltaIoTCommons.LOWER_PACKET_LOSS.isNotSatisfied(packetLoss);
    }

    private boolean isEnergyConsumptionViolated(double energyConsumtption) {
        return DeltaIoTCommons.LOWER_ENERGY_CONSUMPTION.isNotSatisfied(energyConsumtption);
    }

    public static class DeltaIoTReconfigurationStrategy2Builder {
        private final DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess;
        private final SimulationParameters simulationParameters;
        private final SystemConfigurationTracker systemConfigurationTracker;
        private final IDeltaIoToReconfCustomizerResolver reconfCustomizerResolver;
        private String id;
        private QualityBasedReconfigurationPlanner planner;
        private PrismSimulatedMeasurementSpec packetLossSpec;
        private PrismSimulatedMeasurementSpec energyConsumptionSpec;

        public DeltaIoTReconfigurationStrategy2Builder(DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess, SimulationParameters simulationParameters, SystemConfigurationTracker systemConfigurationTracker, IDeltaIoToReconfCustomizerResolver reconfCustomizerResolver) {
            this.modelAccess = modelAccess;
            this.simulationParameters = simulationParameters;
            this.systemConfigurationTracker = systemConfigurationTracker;
            this.reconfCustomizerResolver = reconfCustomizerResolver;
        }

        public DeltaIoTReconfigurationStrategy2Builder withID(String id) {
            this.id = id;
            return this;
        }

        public DeltaIoTReconfigurationStrategy2Builder andPacketLossSpec(PrismSimulatedMeasurementSpec packetLossSpec) {
            this.packetLossSpec = packetLossSpec;
            return this;
        }

        public DeltaIoTReconfigurationStrategy2Builder andEnergyConsumptionSpec(PrismSimulatedMeasurementSpec energyConsumptionSpec) {
            this.energyConsumptionSpec = energyConsumptionSpec;
            return this;
        }

        public DeltaIoTReconfigurationStrategy2Builder andPlanner(QualityBasedReconfigurationPlanner planner) {
            this.planner = planner;
            return this;
        }

        public DeltaIoTReconfigurationStrategy2 build() {
            Objects.requireNonNull(this.id, "ID must be specified.");
            if (this.id.isBlank()) {
                throw new IllegalArgumentException("ID is not properly specified.");
            }
            Objects.requireNonNull(this.packetLossSpec, "Packet loss spec is missing");
            Objects.requireNonNull(this.energyConsumptionSpec, "Energy consumption spec is missing");
            Objects.requireNonNull(this.planner, "Planner is missing.");
            return new DeltaIoTReconfigurationStrategy2(this.id, this.planner, this.packetLossSpec, this.energyConsumptionSpec, this.modelAccess, this.simulationParameters, this.systemConfigurationTracker, this.reconfCustomizerResolver);
        }
    }
}

