/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot.strategy;

import com.google.common.math.DoubleMath;
import de.uka.ipd.sdq.stoex.VariableReference;
import java.util.Map;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.simexp.core.strategy.SharedKnowledge;
import org.palladiosimulator.simexp.core.util.Threshold;
import org.palladiosimulator.simexp.pcm.action.QVToReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.param.reconfigurationparams.DeltaIoTReconfigurationParamRepository;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration.IDeltaIoToReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration.IDistributionFactorReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.reconfiguration.ITransmissionPowerReconfiguration;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.strategy.IDeltaIoToReconfCustomizerResolver;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.strategy.MoteContext;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.strategy.QualityBasedReconfigurationPlanner;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.DeltaIoTModelAccess;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.ReconfigurationParameterCalculator;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class LocalQualityBasedReconfigurationPlanner
implements QualityBasedReconfigurationPlanner {
    private final ReconfigurationParameterCalculator paramCalculator;
    private final IDeltaIoToReconfCustomizerResolver reconfCustomizerResolver;

    public LocalQualityBasedReconfigurationPlanner(DeltaIoTReconfigurationParamRepository reconfParamsRepo, DeltaIoTModelAccess<PCMInstance, QVTOReconfigurator> modelAccess, IDeltaIoToReconfCustomizerResolver reconfCustomizerResolver) {
        this.paramCalculator = new ReconfigurationParameterCalculator(reconfParamsRepo, modelAccess);
        this.reconfCustomizerResolver = reconfCustomizerResolver;
    }

    @Override
    public QVToReconfiguration planEnergyConsumption(SharedKnowledge knowledge) {
        IDeltaIoToReconfiguration reconfiguration = this.reconfCustomizerResolver.resolveDeltaIoTReconfCustomizer(knowledge);
        this.decreaseTransmissionPowerLocally((ITransmissionPowerReconfiguration)reconfiguration, knowledge);
        this.decreaseDistributionLocally((IDistributionFactorReconfiguration)reconfiguration, knowledge);
        return reconfiguration;
    }

    @Override
    public QVToReconfiguration planPacketLoss(SharedKnowledge knowledge) {
        IDeltaIoToReconfiguration reconfiguration = this.reconfCustomizerResolver.resolveDeltaIoTReconfCustomizer(knowledge);
        this.increaseTransmissionPowerLocally((ITransmissionPowerReconfiguration)reconfiguration, knowledge);
        this.increaseDistributionLocally((IDistributionFactorReconfiguration)reconfiguration, knowledge);
        return reconfiguration;
    }

    private void increaseDistributionLocally(IDistributionFactorReconfiguration reconfiguration, SharedKnowledge knowledge) {
        MoteContext.MoteContextFilter motesFilter = new MoteContext.MoteContextFilter(knowledge);
        for (MoteContext each : motesFilter.motesWithTwoLinks()) {
            MoteContext.WirelessLink linkToDecrease = motesFilter.linkWithSmallestSNR(each);
            if (!this.isGreaterThanZero(linkToDecrease.distributionFactor)) continue;
            this.adjustDistributionFactor(linkToDecrease, each, reconfiguration);
        }
    }

    private void decreaseDistributionLocally(IDistributionFactorReconfiguration reconfiguration, SharedKnowledge knowledge) {
        MoteContext.MoteContextFilter motesFilter = new MoteContext.MoteContextFilter(knowledge);
        for (MoteContext each : motesFilter.motesWithTwoLinks()) {
            if (!each.hasUnequalTransmissionPower()) continue;
            MoteContext.WirelessLink linkToDecrease = motesFilter.linkWithHighestTransmissionPower(each);
            if (!this.isGreaterThanZero(linkToDecrease.distributionFactor)) continue;
            this.adjustDistributionFactor(linkToDecrease, each, reconfiguration);
        }
    }

    private void increaseTransmissionPowerLocally(ITransmissionPowerReconfiguration reconfiguration, SharedKnowledge knowledge) {
        Map<MoteContext, MoteContext.WirelessLink> motesWithLowSNRLinks = new MoteContext.MoteContextFilter(knowledge).motesWithSNRLowerThan(Threshold.lessThan((double)0.0));
        for (MoteContext each : motesWithLowSNRLinks.keySet()) {
            MoteContext.WirelessLink lowSNRLink = motesWithLowSNRLinks.get(each);
            if (!this.isGreaterThanZero(lowSNRLink.distributionFactor) || lowSNRLink.transmissionPower >= 15) continue;
            this.increaseTransmissionPower(each.mote, lowSNRLink, reconfiguration);
        }
    }

    private void decreaseTransmissionPowerLocally(ITransmissionPowerReconfiguration reconfiguration, SharedKnowledge knowledge) {
        Map<MoteContext, MoteContext.WirelessLink> motesWithHighSNRLinks = new MoteContext.MoteContextFilter(knowledge).motesWithSNRHigherThan(Threshold.greaterThanOrEqualTo((double)0.0));
        for (MoteContext each : motesWithHighSNRLinks.keySet()) {
            MoteContext.WirelessLink highSNRLink = motesWithHighSNRLinks.get(each);
            if (!this.isGreaterThanZero(highSNRLink.distributionFactor) || highSNRLink.transmissionPower <= 0) continue;
            this.decreaseTransmissionPower(each.mote, highSNRLink, reconfiguration);
        }
    }

    private void decreaseTransmissionPower(AssemblyContext mote, MoteContext.WirelessLink link, ITransmissionPowerReconfiguration reconfiguration) {
        Map<VariableReference, Integer> adjustedParams = this.paramCalculator.computeDecreasedTransmissionPower(mote, link);
        reconfiguration.adjustTransmissionPower(adjustedParams);
    }

    private void increaseTransmissionPower(AssemblyContext mote, MoteContext.WirelessLink link, ITransmissionPowerReconfiguration reconfiguration) {
        Map<VariableReference, Integer> adjustedParams = this.paramCalculator.computeIncreasedTransmissionPower(mote, link);
        reconfiguration.adjustTransmissionPower(adjustedParams);
    }

    private void adjustDistributionFactor(MoteContext.WirelessLink linkToDecrease, MoteContext mote, IDistributionFactorReconfiguration reconfiguration) {
        Map<ProbabilisticBranchTransition, Double> adjustedParams = this.paramCalculator.computeAdjustedDistributionFactors(linkToDecrease, mote);
        reconfiguration.adjustDistributionFactor(adjustedParams);
    }

    private boolean isGreaterThanZero(double distributionFactor) {
        double TOLERANCE = 1.0E-4;
        return !DoubleMath.fuzzyEquals((double)distributionFactor, (double)0.0, (double)TOLERANCE) && distributionFactor > 0.0;
    }
}

