/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simexp.pcm.examples.deltaiot.util;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.palladiosimulator.simexp.core.strategy.SharedKnowledge;
import org.palladiosimulator.simexp.pcm.config.SimulationParameters;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.strategy.MoteContext;
import org.palladiosimulator.simexp.pcm.examples.deltaiot.util.IConfigurationStatisticSink;

public class SystemConfigurationTracker {
    private static final Logger LOGGER = Logger.getLogger(SystemConfigurationTracker.class);
    private final List<IConfigurationStatisticSink> configurationStatisticSinks;
    private final SimulationParameters simulationParameters;
    private int run;

    public SystemConfigurationTracker(SimulationParameters simulationParameters) {
        this.simulationParameters = simulationParameters;
        this.configurationStatisticSinks = Lists.newArrayList();
        this.run = 0;
    }

    public void addStatisticSink(IConfigurationStatisticSink sink) {
        this.configurationStatisticSinks.add(sink);
    }

    public void prepareNetworkConfig() {
        if (this.run > 0) {
            return;
        }
        for (IConfigurationStatisticSink sink : this.configurationStatisticSinks) {
            try {
                sink.initialize();
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void processNetworkConfig(SharedKnowledge knowledge) {
        this.runStart();
        MoteContext.MoteContextFilter moteFiler = new MoteContext.MoteContextFilter(knowledge);
        for (MoteContext eachMote : moteFiler.getAllMoteContexts()) {
            for (MoteContext.WirelessLink eachLink : eachMote.links) {
                for (IConfigurationStatisticSink sink : this.configurationStatisticSinks) {
                    try {
                        sink.onEntry(this.run, eachLink);
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        this.runFinish();
        ++this.run;
        if (this.isLastRun()) {
            this.saveNetworkConfigs();
            this.run = 0;
        }
    }

    private void saveNetworkConfigs() {
        for (IConfigurationStatisticSink sink : this.configurationStatisticSinks) {
            try {
                sink.finalize();
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean isLastRun() {
        return this.run == this.simulationParameters.getNumberOfSimulationsPerRun() - 1;
    }

    private void runStart() {
        for (IConfigurationStatisticSink sink : this.configurationStatisticSinks) {
            try {
                sink.onRunStart(this.run);
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void runFinish() {
        for (IConfigurationStatisticSink sink : this.configurationStatisticSinks) {
            try {
                sink.onRunFinish(this.run);
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

